@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * SSL certificate for an app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2015-08-01, 2016-03-01, 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create Or Update Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.Web.Certificate("certificate", new()
 *     {
 *         HostNames = new[]
 *         {
 *             "ServerCert",
 *         },
 *         Location = "East US",
 *         Name = "testc6282",
 *         Password = "<password>",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewCertificate(ctx, "certificate", &web.CertificateArgs{
 * 			HostNames: pulumi.StringArray{
 * 				pulumi.String("ServerCert"),
 * 			},
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("testc6282"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.Certificate;
 * import com.pulumi.azurenative.web.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .hostNames("ServerCert")
 *             .location("East US")
 *             .name("testc6282")
 *             .password("<password>")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:Certificate testc6282 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/certificates/{name}
 * ```
 * @property canonicalName CNAME of the certificate to be issued via free certificate
 * @property domainValidationMethod Method of domain validation for free cert
 * @property hostNames Host names the certificate applies to.
 * @property keyVaultId Key Vault Csm resource Id.
 * @property keyVaultSecretName Key Vault secret name.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property name Name of the certificate.
 * @property password Certificate password.
 * @property pfxBlob Pfx blob.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property serverFarmId Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
 * @property tags Resource tags.
 */
public data class CertificateArgs(
    public val canonicalName: Output<String>? = null,
    public val domainValidationMethod: Output<String>? = null,
    public val hostNames: Output<List<String>>? = null,
    public val keyVaultId: Output<String>? = null,
    public val keyVaultSecretName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
    public val pfxBlob: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverFarmId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.CertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.web.CertificateArgs =
        com.pulumi.azurenative.web.CertificateArgs.builder()
            .canonicalName(canonicalName?.applyValue({ args0 -> args0 }))
            .domainValidationMethod(domainValidationMethod?.applyValue({ args0 -> args0 }))
            .hostNames(hostNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .keyVaultSecretName(keyVaultSecretName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .pfxBlob(pfxBlob?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverFarmId(serverFarmId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var canonicalName: Output<String>? = null

    private var domainValidationMethod: Output<String>? = null

    private var hostNames: Output<List<String>>? = null

    private var keyVaultId: Output<String>? = null

    private var keyVaultSecretName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var pfxBlob: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverFarmId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value CNAME of the certificate to be issued via free certificate
     */
    @JvmName("palcqeopyqabskoa")
    public suspend fun canonicalName(`value`: Output<String>) {
        this.canonicalName = value
    }

    /**
     * @param value Method of domain validation for free cert
     */
    @JvmName("gpfnfjeutnravsrh")
    public suspend fun domainValidationMethod(`value`: Output<String>) {
        this.domainValidationMethod = value
    }

    /**
     * @param value Host names the certificate applies to.
     */
    @JvmName("urqfvlygvkuiytmp")
    public suspend fun hostNames(`value`: Output<List<String>>) {
        this.hostNames = value
    }

    @JvmName("bophvtcmgpcnuwab")
    public suspend fun hostNames(vararg values: Output<String>) {
        this.hostNames = Output.all(values.asList())
    }

    /**
     * @param values Host names the certificate applies to.
     */
    @JvmName("ukeewhfgopfnekwi")
    public suspend fun hostNames(values: List<Output<String>>) {
        this.hostNames = Output.all(values)
    }

    /**
     * @param value Key Vault Csm resource Id.
     */
    @JvmName("vgwplaygwwuhpcvj")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value Key Vault secret name.
     */
    @JvmName("ssxdugtysdiymreh")
    public suspend fun keyVaultSecretName(`value`: Output<String>) {
        this.keyVaultSecretName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("oqpodytalcamguwa")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("xdbqvvunysxherlg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the certificate.
     */
    @JvmName("oporuagvlmeirebg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Certificate password.
     */
    @JvmName("mqqtqsejpfxnhqji")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Pfx blob.
     */
    @JvmName("gwbowcjtwmmirrrh")
    public suspend fun pfxBlob(`value`: Output<String>) {
        this.pfxBlob = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bqxyodobgtagmttv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
     */
    @JvmName("vnyyfawydnehjybl")
    public suspend fun serverFarmId(`value`: Output<String>) {
        this.serverFarmId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vcoaihpcbdphkphv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value CNAME of the certificate to be issued via free certificate
     */
    @JvmName("oxjjbubemhofirpy")
    public suspend fun canonicalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canonicalName = mapped
    }

    /**
     * @param value Method of domain validation for free cert
     */
    @JvmName("bhayfyifilhsdtdo")
    public suspend fun domainValidationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainValidationMethod = mapped
    }

    /**
     * @param value Host names the certificate applies to.
     */
    @JvmName("nmoafsrswbctipra")
    public suspend fun hostNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNames = mapped
    }

    /**
     * @param values Host names the certificate applies to.
     */
    @JvmName("ycxcnexmqwfksquw")
    public suspend fun hostNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostNames = mapped
    }

    /**
     * @param value Key Vault Csm resource Id.
     */
    @JvmName("iuwspltjpmreihvl")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value Key Vault secret name.
     */
    @JvmName("idgtxmxjnkxtrksh")
    public suspend fun keyVaultSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretName = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ugasxintfybkwrfr")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("yimklyneckmylouv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the certificate.
     */
    @JvmName("aqqbxwlkwkvtkxsc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Certificate password.
     */
    @JvmName("stfdipnxkgwlidnc")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Pfx blob.
     */
    @JvmName("tlrtvgkeonscvcdb")
    public suspend fun pfxBlob(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pfxBlob = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("wfisnrqctkxrowiu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
     */
    @JvmName("fycjlxioxkmlkefh")
    public suspend fun serverFarmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverFarmId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kxlcehchmvdgfkog")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tqgvxjnrevbgfran")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        canonicalName = canonicalName,
        domainValidationMethod = domainValidationMethod,
        hostNames = hostNames,
        keyVaultId = keyVaultId,
        keyVaultSecretName = keyVaultSecretName,
        kind = kind,
        location = location,
        name = name,
        password = password,
        pfxBlob = pfxBlob,
        resourceGroupName = resourceGroupName,
        serverFarmId = serverFarmId,
        tags = tags,
    )
}
