@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.ContainerAppArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.ConfigurationArgs
import com.pulumi.azurenative.web.kotlin.inputs.ConfigurationArgsBuilder
import com.pulumi.azurenative.web.kotlin.inputs.TemplateArgs
import com.pulumi.azurenative.web.kotlin.inputs.TemplateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Container App.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### Create or Update Container App
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerApp = new AzureNative.Web.ContainerApp("containerApp", new()
 *     {
 *         Configuration = new AzureNative.Web.Inputs.ConfigurationArgs
 *         {
 *             Ingress = new AzureNative.Web.Inputs.IngressArgs
 *             {
 *                 External = true,
 *                 TargetPort = 3000,
 *             },
 *         },
 *         Kind = "containerApp",
 *         KubeEnvironmentId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/kubeEnvironments/demokube",
 *         Location = "East US",
 *         Name = "testcontainerApp0",
 *         ResourceGroupName = "rg",
 *         Template = new AzureNative.Web.Inputs.TemplateArgs
 *         {
 *             Containers = new[]
 *             {
 *                 new AzureNative.Web.Inputs.ContainerArgs
 *                 {
 *                     Image = "repo/testcontainerApp0:v1",
 *                     Name = "testcontainerApp0",
 *                 },
 *             },
 *             Dapr = new AzureNative.Web.Inputs.DaprArgs
 *             {
 *                 AppPort = 3000,
 *                 Enabled = true,
 *             },
 *             Scale = new AzureNative.Web.Inputs.ScaleArgs
 *             {
 *                 MaxReplicas = 5,
 *                 MinReplicas = 1,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Web.Inputs.ScaleRuleArgs
 *                     {
 *                         Custom = new AzureNative.Web.Inputs.CustomScaleRuleArgs
 *                         {
 *                             Metadata =
 *                             {
 *                                 { "concurrentRequests", "50" },
 *                             },
 *                             Type = "http",
 *                         },
 *                         Name = "httpscalingrule",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewContainerApp(ctx, "containerApp", &web.ContainerAppArgs{
 * 			Configuration: &web.ConfigurationArgs{
 * 				Ingress: &web.IngressArgs{
 * 					External:   pulumi.Bool(true),
 * 					TargetPort: pulumi.Int(3000),
 * 				},
 * 			},
 * 			Kind:              pulumi.String("containerApp"),
 * 			KubeEnvironmentId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/kubeEnvironments/demokube"),
 * 			Location:          pulumi.String("East US"),
 * 			Name:              pulumi.String("testcontainerApp0"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Template: &web.TemplateArgs{
 * 				Containers: web.ContainerArray{
 * 					&web.ContainerArgs{
 * 						Image: pulumi.String("repo/testcontainerApp0:v1"),
 * 						Name:  pulumi.String("testcontainerApp0"),
 * 					},
 * 				},
 * 				Dapr: &web.DaprArgs{
 * 					AppPort: pulumi.Int(3000),
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 				Scale: &web.ScaleArgs{
 * 					MaxReplicas: pulumi.Int(5),
 * 					MinReplicas: pulumi.Int(1),
 * 					Rules: web.ScaleRuleArray{
 * 						&web.ScaleRuleArgs{
 * 							Custom: &web.CustomScaleRuleArgs{
 * 								Metadata: pulumi.StringMap{
 * 									"concurrentRequests": pulumi.String("50"),
 * 								},
 * 								Type: pulumi.String("http"),
 * 							},
 * 							Name: pulumi.String("httpscalingrule"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.ContainerApp;
 * import com.pulumi.azurenative.web.ContainerAppArgs;
 * import com.pulumi.azurenative.web.inputs.ConfigurationArgs;
 * import com.pulumi.azurenative.web.inputs.IngressArgs;
 * import com.pulumi.azurenative.web.inputs.TemplateArgs;
 * import com.pulumi.azurenative.web.inputs.DaprArgs;
 * import com.pulumi.azurenative.web.inputs.ScaleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerApp = new ContainerApp("containerApp", ContainerAppArgs.builder()
 *             .configuration(ConfigurationArgs.builder()
 *                 .ingress(IngressArgs.builder()
 *                     .external(true)
 *                     .targetPort(3000)
 *                     .build())
 *                 .build())
 *             .kind("containerApp")
 *             .kubeEnvironmentId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.Web/kubeEnvironments/demokube")
 *             .location("East US")
 *             .name("testcontainerApp0")
 *             .resourceGroupName("rg")
 *             .template(TemplateArgs.builder()
 *                 .containers(ContainerArgs.builder()
 *                     .image("repo/testcontainerApp0:v1")
 *                     .name("testcontainerApp0")
 *                     .build())
 *                 .dapr(DaprArgs.builder()
 *                     .appPort(3000)
 *                     .enabled(true)
 *                     .build())
 *                 .scale(ScaleArgs.builder()
 *                     .maxReplicas(5)
 *                     .minReplicas(1)
 *                     .rules(ScaleRuleArgs.builder()
 *                         .custom(CustomScaleRuleArgs.builder()
 *                             .metadata(Map.of("concurrentRequests", "50"))
 *                             .type("http")
 *                             .build())
 *                         .name("httpscalingrule")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:ContainerApp testcontainerApp0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/containerApps/{name}
 * ```
 * @property configuration Non versioned Container App configuration properties.
 * @property kind Kind of resource.
 * @property kubeEnvironmentId Resource ID of the Container App's KubeEnvironment.
 * @property location Resource Location.
 * @property name Name of the Container App.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property tags Resource tags.
 * @property template Container App versioned application definition.
 */
public data class ContainerAppArgs(
    public val configuration: Output<ConfigurationArgs>? = null,
    public val kind: Output<String>? = null,
    public val kubeEnvironmentId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val template: Output<TemplateArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.ContainerAppArgs> {
    override fun toJava(): com.pulumi.azurenative.web.ContainerAppArgs =
        com.pulumi.azurenative.web.ContainerAppArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kubeEnvironmentId(kubeEnvironmentId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .template(template?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ContainerAppArgs].
 */
@PulumiTagMarker
public class ContainerAppArgsBuilder internal constructor() {
    private var configuration: Output<ConfigurationArgs>? = null

    private var kind: Output<String>? = null

    private var kubeEnvironmentId: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var template: Output<TemplateArgs>? = null

    /**
     * @param value Non versioned Container App configuration properties.
     */
    @JvmName("wishijnpqsjvswsc")
    public suspend fun configuration(`value`: Output<ConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("eymxrfuppemjhibw")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource ID of the Container App's KubeEnvironment.
     */
    @JvmName("gbodwprubywoipsl")
    public suspend fun kubeEnvironmentId(`value`: Output<String>) {
        this.kubeEnvironmentId = value
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("akbrrcjneuixerau")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("rqabftkvpnkyaaam")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("wyiiqawcdepvbvee")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("navxuvjioxbxukab")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Container App versioned application definition.
     */
    @JvmName("xutfqnpkrjpxyevk")
    public suspend fun template(`value`: Output<TemplateArgs>) {
        this.template = value
    }

    /**
     * @param value Non versioned Container App configuration properties.
     */
    @JvmName("lhiexfktvvlaywnc")
    public suspend fun configuration(`value`: ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Non versioned Container App configuration properties.
     */
    @JvmName("cnohrfommrdpcnjw")
    public suspend fun configuration(argument: suspend ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("wrlxykdtrxcrtnaf")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource ID of the Container App's KubeEnvironment.
     */
    @JvmName("dhcuwkpmeeymplhm")
    public suspend fun kubeEnvironmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeEnvironmentId = mapped
    }

    /**
     * @param value Resource Location.
     */
    @JvmName("dabndlnbosshhwlm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Container App.
     */
    @JvmName("gfethtbmcwasruqn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("vfdgsicqmcpdbxwy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vtsqlatddctwqqfc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hkyfambiedkuurtl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Container App versioned application definition.
     */
    @JvmName("aswhafnwbcbwtgxm")
    public suspend fun template(`value`: TemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    /**
     * @param argument Container App versioned application definition.
     */
    @JvmName("ockqkrlwohaudghb")
    public suspend fun template(argument: suspend TemplateArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.template = mapped
    }

    internal fun build(): ContainerAppArgs = ContainerAppArgs(
        configuration = configuration,
        kind = kind,
        kubeEnvironmentId = kubeEnvironmentId,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
        template = template,
    )
}
