@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.CustomApiPropertiesDefinitionResponse
import com.pulumi.azurenative.web.kotlin.outputs.CustomApiPropertiesDefinitionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CustomApi].
 */
@PulumiTagMarker
public class CustomApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomApiArgs = CustomApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomApiArgsBuilder.() -> Unit) {
        val builder = CustomApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomApi {
        val builtJavaResource = com.pulumi.azurenative.web.CustomApi(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomApi(builtJavaResource)
    }
}

/**
 * A custom API
 * Azure REST API version: 2016-06-01. Prior API version in Azure Native 1.x: 2016-06-01.
 * ## Example Usage
 * ### Replace a custom API
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customApi = new AzureNative.Web.CustomApi("customApi", new()
 *     {
 *         ApiName = "testCustomApi",
 *         Properties = new AzureNative.Web.Inputs.CustomApiPropertiesDefinitionArgs
 *         {
 *             ApiDefinitions = new AzureNative.Web.Inputs.ApiResourceDefinitionsArgs
 *             {
 *                 OriginalSwaggerUrl = "https://tempuri.org/swagger.json",
 *             },
 *             ApiType = AzureNative.Web.ApiType.Rest,
 *             Capabilities = new() { },
 *             Description = "",
 *             DisplayName = "testCustomApi",
 *             IconUri = "/testIcon.svg",
 *         },
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewCustomApi(ctx, "customApi", &web.CustomApiArgs{
 * 			ApiName: pulumi.String("testCustomApi"),
 * 			Properties: &web.CustomApiPropertiesDefinitionArgs{
 * 				ApiDefinitions: &web.ApiResourceDefinitionsArgs{
 * 					OriginalSwaggerUrl: pulumi.String("https://tempuri.org/swagger.json"),
 * 				},
 * 				ApiType:      pulumi.String(web.ApiTypeRest),
 * 				Capabilities: pulumi.StringArray{},
 * 				Description:  pulumi.String(""),
 * 				DisplayName:  pulumi.String("testCustomApi"),
 * 				IconUri:      pulumi.String("/testIcon.svg"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.CustomApi;
 * import com.pulumi.azurenative.web.CustomApiArgs;
 * import com.pulumi.azurenative.web.inputs.CustomApiPropertiesDefinitionArgs;
 * import com.pulumi.azurenative.web.inputs.ApiResourceDefinitionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customApi = new CustomApi("customApi", CustomApiArgs.builder()
 *             .apiName("testCustomApi")
 *             .properties(CustomApiPropertiesDefinitionArgs.builder()
 *                 .apiDefinitions(ApiResourceDefinitionsArgs.builder()
 *                     .originalSwaggerUrl("https://tempuri.org/swagger.json")
 *                     .build())
 *                 .apiType("Rest")
 *                 .capabilities()
 *                 .description("")
 *                 .displayName("testCustomApi")
 *                 .iconUri("/testIcon.svg")
 *                 .build())
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:CustomApi testCustomApi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/customApis/{apiName}
 * ```
 */
public class CustomApi internal constructor(
    override val javaResource: com.pulumi.azurenative.web.CustomApi,
) : KotlinCustomResource(javaResource, CustomApiMapper) {
    /**
     * Resource ETag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Custom API properties
     */
    public val properties: Output<CustomApiPropertiesDefinitionResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomApiMapper : ResourceMapper<CustomApi> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.CustomApi::class == javaResource::class

    override fun map(javaResource: Resource): CustomApi = CustomApi(
        javaResource as
            com.pulumi.azurenative.web.CustomApi,
    )
}

/**
 * @see [CustomApi].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomApi].
 */
public suspend fun customApi(name: String, block: suspend CustomApiResourceBuilder.() -> Unit):
    CustomApi {
    val builder = CustomApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomApi].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customApi(name: String): CustomApi {
    val builder = CustomApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
