@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.DatabaseConnectionOverviewResponse
import com.pulumi.azurenative.web.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.web.kotlin.outputs.ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse
import com.pulumi.azurenative.web.kotlin.outputs.SkuDescriptionResponse
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteBuildPropertiesResponse
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteLinkedBackendResponse
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteTemplateOptionsResponse
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteUserProvidedFunctionAppResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.web.kotlin.outputs.DatabaseConnectionOverviewResponse.Companion.toKotlin as databaseConnectionOverviewResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse.Companion.toKotlin as responseMessageEnvelopeRemotePrivateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.SkuDescriptionResponse.Companion.toKotlin as skuDescriptionResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteBuildPropertiesResponse.Companion.toKotlin as staticSiteBuildPropertiesResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteLinkedBackendResponse.Companion.toKotlin as staticSiteLinkedBackendResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteTemplateOptionsResponse.Companion.toKotlin as staticSiteTemplateOptionsResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteUserProvidedFunctionAppResponse.Companion.toKotlin as staticSiteUserProvidedFunctionAppResponseToKotlin

/**
 * Builder for [StaticSite].
 */
@PulumiTagMarker
public class StaticSiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticSiteArgs = StaticSiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticSiteArgsBuilder.() -> Unit) {
        val builder = StaticSiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StaticSite {
        val builtJavaResource = com.pulumi.azurenative.web.StaticSite(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StaticSite(builtJavaResource)
    }
}

/**
 * Static Site ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2021-02-01, 2023-01-01.
 * ## Example Usage
 * ### Create or update a static site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSite = new AzureNative.Web.StaticSite("staticSite", new()
 *     {
 *         Branch = "master",
 *         BuildProperties = new AzureNative.Web.Inputs.StaticSiteBuildPropertiesArgs
 *         {
 *             ApiLocation = "api",
 *             AppArtifactLocation = "build",
 *             AppLocation = "app",
 *         },
 *         Location = "West US 2",
 *         Name = "testStaticSite0",
 *         RepositoryToken = "repoToken123",
 *         RepositoryUrl = "https://github.com/username/RepoName",
 *         ResourceGroupName = "rg",
 *         Sku = new AzureNative.Web.Inputs.SkuDescriptionArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Basic",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSite(ctx, "staticSite", &web.StaticSiteArgs{
 * 			Branch: pulumi.String("master"),
 * 			BuildProperties: &web.StaticSiteBuildPropertiesArgs{
 * 				ApiLocation:         pulumi.String("api"),
 * 				AppArtifactLocation: pulumi.String("build"),
 * 				AppLocation:         pulumi.String("app"),
 * 			},
 * 			Location:          pulumi.String("West US 2"),
 * 			Name:              pulumi.String("testStaticSite0"),
 * 			RepositoryToken:   pulumi.String("repoToken123"),
 * 			RepositoryUrl:     pulumi.String("https://github.com/username/RepoName"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			Sku: &web.SkuDescriptionArgs{
 * 				Name: pulumi.String("Basic"),
 * 				Tier: pulumi.String("Basic"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSite;
 * import com.pulumi.azurenative.web.StaticSiteArgs;
 * import com.pulumi.azurenative.web.inputs.StaticSiteBuildPropertiesArgs;
 * import com.pulumi.azurenative.web.inputs.SkuDescriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSite = new StaticSite("staticSite", StaticSiteArgs.builder()
 *             .branch("master")
 *             .buildProperties(StaticSiteBuildPropertiesArgs.builder()
 *                 .apiLocation("api")
 *                 .appArtifactLocation("build")
 *                 .appLocation("app")
 *                 .build())
 *             .location("West US 2")
 *             .name("testStaticSite0")
 *             .repositoryToken("repoToken123")
 *             .repositoryUrl("https://github.com/username/RepoName")
 *             .resourceGroupName("rg")
 *             .sku(SkuDescriptionArgs.builder()
 *                 .name("Basic")
 *                 .tier("Basic")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSite testStaticSite0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}
 * ```
 */
public class StaticSite internal constructor(
    override val javaResource: com.pulumi.azurenative.web.StaticSite,
) : KotlinCustomResource(javaResource, StaticSiteMapper) {
    /**
     * <code>false</code> if config file is locked for this static web app; otherwise, <code>true</code>.
     */
    public val allowConfigFileUpdates: Output<Boolean>?
        get() = javaResource.allowConfigFileUpdates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The target branch in the repository.
     */
    public val branch: Output<String>?
        get() = javaResource.branch().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Build properties to configure on the repository.
     */
    public val buildProperties: Output<StaticSiteBuildPropertiesResponse>?
        get() = javaResource.buildProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> staticSiteBuildPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The content distribution endpoint for the static site.
     */
    public val contentDistributionEndpoint: Output<String>
        get() = javaResource.contentDistributionEndpoint().applyValue({ args0 -> args0 })

    /**
     * The custom domains associated with this static site.
     */
    public val customDomains: Output<List<String>>
        get() = javaResource.customDomains().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Database connections for the static site
     */
    public val databaseConnections: Output<List<DatabaseConnectionOverviewResponse>>
        get() = javaResource.databaseConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> databaseConnectionOverviewResponseToKotlin(args0) })
            })
        })

    /**
     * The default autogenerated hostname for the static site.
     */
    public val defaultHostname: Output<String>
        get() = javaResource.defaultHostname().applyValue({ args0 -> args0 })

    /**
     * State indicating the status of the enterprise grade CDN serving traffic to the static web app.
     */
    public val enterpriseGradeCdnStatus: Output<String>?
        get() = javaResource.enterpriseGradeCdnStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Managed service identity.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Identity to use for Key Vault Reference authentication.
     */
    public val keyVaultReferenceIdentity: Output<String>
        get() = javaResource.keyVaultReferenceIdentity().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Backends linked to the static side
     */
    public val linkedBackends: Output<List<StaticSiteLinkedBackendResponse>>
        get() = javaResource.linkedBackends().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> staticSiteLinkedBackendResponseToKotlin(args0) })
            })
        })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Private endpoint connections
     */
    public val privateEndpointConnections:
        Output<List<ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    responseMessageEnvelopeRemotePrivateEndpointConnectionResponseToKotlin(args0)
                })
            })
        })

    /**
     * The provider that submitted the last deployment to the primary environment of the static site.
     */
    public val provider: Output<String>?
        get() = javaResource.provider().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * State indicating whether public traffic are allowed or not for a static web app. Allowed Values: 'Enabled', 'Disabled' or an empty string.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
     */
    public val repositoryToken: Output<String>?
        get() = javaResource.repositoryToken().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * URL for the repository of the static site.
     */
    public val repositoryUrl: Output<String>?
        get() = javaResource.repositoryUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of a SKU for a scalable resource.
     */
    public val sku: Output<SkuDescriptionResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuDescriptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * State indicating whether staging environments are allowed or not allowed for a static web app.
     */
    public val stagingEnvironmentPolicy: Output<String>?
        get() = javaResource.stagingEnvironmentPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Template options for generating a new repository.
     */
    public val templateProperties: Output<StaticSiteTemplateOptionsResponse>?
        get() = javaResource.templateProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> staticSiteTemplateOptionsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * User provided function apps registered with the static site
     */
    public val userProvidedFunctionApps: Output<List<StaticSiteUserProvidedFunctionAppResponse>>
        get() = javaResource.userProvidedFunctionApps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> staticSiteUserProvidedFunctionAppResponseToKotlin(args0) })
            })
        })
}

public object StaticSiteMapper : ResourceMapper<StaticSite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.StaticSite::class == javaResource::class

    override fun map(javaResource: Resource): StaticSite = StaticSite(
        javaResource as
            com.pulumi.azurenative.web.StaticSite,
    )
}

/**
 * @see [StaticSite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticSite].
 */
public suspend fun staticSite(name: String, block: suspend StaticSiteResourceBuilder.() -> Unit):
    StaticSite {
    val builder = StaticSiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticSite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticSite(name: String): StaticSite {
    val builder = StaticSiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
