@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse
import com.pulumi.azurenative.web.kotlin.outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [StaticSiteBuildDatabaseConnection].
 */
@PulumiTagMarker
public class StaticSiteBuildDatabaseConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticSiteBuildDatabaseConnectionArgs = StaticSiteBuildDatabaseConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticSiteBuildDatabaseConnectionArgsBuilder.() -> Unit) {
        val builder = StaticSiteBuildDatabaseConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StaticSiteBuildDatabaseConnection {
        val builtJavaResource =
            com.pulumi.azurenative.web.StaticSiteBuildDatabaseConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StaticSiteBuildDatabaseConnection(builtJavaResource)
    }
}

/**
 * Static Site Database Connection resource.
 * Azure REST API version: 2022-09-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Create or update a database connection for a static site build
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteBuildDatabaseConnection = new AzureNative.Web.StaticSiteBuildDatabaseConnection("staticSiteBuildDatabaseConnection", new()
 *     {
 *         ConnectionIdentity = "SystemAssigned",
 *         ConnectionString = "AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;",
 *         DatabaseConnectionName = "default",
 *         EnvironmentName = "default",
 *         Name = "testStaticSite0",
 *         Region = "West US 2",
 *         ResourceGroupName = "rg",
 *         ResourceId = "/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteBuildDatabaseConnection(ctx, "staticSiteBuildDatabaseConnection", &web.StaticSiteBuildDatabaseConnectionArgs{
 * 			ConnectionIdentity:     pulumi.String("SystemAssigned"),
 * 			ConnectionString:       pulumi.String("AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;"),
 * 			DatabaseConnectionName: pulumi.String("default"),
 * 			EnvironmentName:        pulumi.String("default"),
 * 			Name:                   pulumi.String("testStaticSite0"),
 * 			Region:                 pulumi.String("West US 2"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			ResourceId:             pulumi.String("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteBuildDatabaseConnection;
 * import com.pulumi.azurenative.web.StaticSiteBuildDatabaseConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteBuildDatabaseConnection = new StaticSiteBuildDatabaseConnection("staticSiteBuildDatabaseConnection", StaticSiteBuildDatabaseConnectionArgs.builder()
 *             .connectionIdentity("SystemAssigned")
 *             .connectionString("AccountEndpoint=https://exampleDatabaseName.documents.azure.com:443/;Database=mydb;")
 *             .databaseConnectionName("default")
 *             .environmentName("default")
 *             .name("testStaticSite0")
 *             .region("West US 2")
 *             .resourceGroupName("rg")
 *             .resourceId("/subscription/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/databaseRG/providers/Microsoft.DocumentDB/databaseAccounts/exampleDatabaseName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteBuildDatabaseConnection default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{environmentName}/databaseConnections/{databaseConnectionName}
 * ```
 */
public class StaticSiteBuildDatabaseConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.web.StaticSiteBuildDatabaseConnection,
) : KotlinCustomResource(javaResource, StaticSiteBuildDatabaseConnectionMapper) {
    /**
     * A list of configuration files associated with this database connection.
     */
    public val configurationFiles:
        Output<List<StaticSiteDatabaseConnectionConfigurationFileOverviewResponse>>
        get() = javaResource.configurationFiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
     */
    public val connectionIdentity: Output<String>?
        get() = javaResource.connectionIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection string to use to connect to the database.
     */
    public val connectionString: Output<String>?
        get() = javaResource.connectionString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The region of the database resource.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * The resource id of the database.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StaticSiteBuildDatabaseConnectionMapper :
    ResourceMapper<StaticSiteBuildDatabaseConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.StaticSiteBuildDatabaseConnection::class == javaResource::class

    override fun map(javaResource: Resource): StaticSiteBuildDatabaseConnection =
        StaticSiteBuildDatabaseConnection(
            javaResource as
                com.pulumi.azurenative.web.StaticSiteBuildDatabaseConnection,
        )
}

/**
 * @see [StaticSiteBuildDatabaseConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticSiteBuildDatabaseConnection].
 */
public suspend fun staticSiteBuildDatabaseConnection(
    name: String,
    block: suspend StaticSiteBuildDatabaseConnectionResourceBuilder.() -> Unit,
):
    StaticSiteBuildDatabaseConnection {
    val builder = StaticSiteBuildDatabaseConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticSiteBuildDatabaseConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticSiteBuildDatabaseConnection(name: String): StaticSiteBuildDatabaseConnection {
    val builder = StaticSiteBuildDatabaseConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
