@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StaticSiteCustomDomain].
 */
@PulumiTagMarker
public class StaticSiteCustomDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StaticSiteCustomDomainArgs = StaticSiteCustomDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StaticSiteCustomDomainArgsBuilder.() -> Unit) {
        val builder = StaticSiteCustomDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StaticSiteCustomDomain {
        val builtJavaResource =
            com.pulumi.azurenative.web.StaticSiteCustomDomain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StaticSiteCustomDomain(builtJavaResource)
    }
}

/**
 * Static Site Custom Domain Overview ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Create or update a custom domain for a static site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var staticSiteCustomDomain = new AzureNative.Web.StaticSiteCustomDomain("staticSiteCustomDomain", new()
 *     {
 *         DomainName = "custom.domain.net",
 *         Name = "testStaticSite0",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewStaticSiteCustomDomain(ctx, "staticSiteCustomDomain", &web.StaticSiteCustomDomainArgs{
 * 			DomainName:        pulumi.String("custom.domain.net"),
 * 			Name:              pulumi.String("testStaticSite0"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.StaticSiteCustomDomain;
 * import com.pulumi.azurenative.web.StaticSiteCustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var staticSiteCustomDomain = new StaticSiteCustomDomain("staticSiteCustomDomain", StaticSiteCustomDomainArgs.builder()
 *             .domainName("custom.domain.net")
 *             .name("testStaticSite0")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:StaticSiteCustomDomain myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}
 * ```
 */
public class StaticSiteCustomDomain internal constructor(
    override val javaResource: com.pulumi.azurenative.web.StaticSiteCustomDomain,
) : KotlinCustomResource(javaResource, StaticSiteCustomDomainMapper) {
    /**
     * The date and time on which the custom domain was created for the static site.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * The domain name for the static site custom domain.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the custom domain
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The TXT record validation token
     */
    public val validationToken: Output<String>
        get() = javaResource.validationToken().applyValue({ args0 -> args0 })
}

public object StaticSiteCustomDomainMapper : ResourceMapper<StaticSiteCustomDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.StaticSiteCustomDomain::class == javaResource::class

    override fun map(javaResource: Resource): StaticSiteCustomDomain =
        StaticSiteCustomDomain(javaResource as com.pulumi.azurenative.web.StaticSiteCustomDomain)
}

/**
 * @see [StaticSiteCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StaticSiteCustomDomain].
 */
public suspend fun staticSiteCustomDomain(
    name: String,
    block: suspend StaticSiteCustomDomainResourceBuilder.() -> Unit,
): StaticSiteCustomDomain {
    val builder = StaticSiteCustomDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StaticSiteCustomDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun staticSiteCustomDomain(name: String): StaticSiteCustomDomain {
    val builder = StaticSiteCustomDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
