@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [WebAppAuthSettings].
 */
@PulumiTagMarker
public class WebAppAuthSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppAuthSettingsArgs = WebAppAuthSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppAuthSettingsArgsBuilder.() -> Unit) {
        val builder = WebAppAuthSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppAuthSettings {
        val builtJavaResource = com.pulumi.azurenative.web.WebAppAuthSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAppAuthSettings(builtJavaResource)
    }
}

/**
 * Configuration settings for the Azure App Service Authentication / Authorization feature.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Update Auth Settings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppAuthSettings = new AzureNative.Web.WebAppAuthSettings("webAppAuthSettings", new()
 *     {
 *         AllowedExternalRedirectUrls = new[]
 *         {
 *             "sitef6141.customdomain.net",
 *             "sitef6141.customdomain.info",
 *         },
 *         ClientId = "42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com",
 *         DefaultProvider = AzureNative.Web.BuiltInAuthenticationProvider.Google,
 *         Enabled = true,
 *         Name = "sitef6141",
 *         ResourceGroupName = "testrg123",
 *         RuntimeVersion = "~1",
 *         TokenRefreshExtensionHours = 120,
 *         TokenStoreEnabled = true,
 *         UnauthenticatedClientAction = AzureNative.Web.UnauthenticatedClientAction.RedirectToLoginPage,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppAuthSettings(ctx, "webAppAuthSettings", &web.WebAppAuthSettingsArgs{
 * 			AllowedExternalRedirectUrls: pulumi.StringArray{
 * 				pulumi.String("sitef6141.customdomain.net"),
 * 				pulumi.String("sitef6141.customdomain.info"),
 * 			},
 * 			ClientId:                    pulumi.String("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com"),
 * 			DefaultProvider:             web.BuiltInAuthenticationProviderGoogle,
 * 			Enabled:                     pulumi.Bool(true),
 * 			Name:                        pulumi.String("sitef6141"),
 * 			ResourceGroupName:           pulumi.String("testrg123"),
 * 			RuntimeVersion:              pulumi.String("~1"),
 * 			TokenRefreshExtensionHours:  pulumi.Float64(120),
 * 			TokenStoreEnabled:           pulumi.Bool(true),
 * 			UnauthenticatedClientAction: web.UnauthenticatedClientActionRedirectToLoginPage,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppAuthSettings;
 * import com.pulumi.azurenative.web.WebAppAuthSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppAuthSettings = new WebAppAuthSettings("webAppAuthSettings", WebAppAuthSettingsArgs.builder()
 *             .allowedExternalRedirectUrls(
 *                 "sitef6141.customdomain.net",
 *                 "sitef6141.customdomain.info")
 *             .clientId("42d795a9-8abb-4d06-8534-39528af40f8e.apps.googleusercontent.com")
 *             .defaultProvider("Google")
 *             .enabled(true)
 *             .name("sitef6141")
 *             .resourceGroupName("testrg123")
 *             .runtimeVersion("~1")
 *             .tokenRefreshExtensionHours(120)
 *             .tokenStoreEnabled(true)
 *             .unauthenticatedClientAction("RedirectToLoginPage")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppAuthSettings authsettings /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings
 * ```
 */
public class WebAppAuthSettings internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppAuthSettings,
) : KotlinCustomResource(javaResource, WebAppAuthSettingsMapper) {
    /**
     * Gets a JSON string containing the Azure AD Acl settings.
     */
    public val aadClaimsAuthorization: Output<String>?
        get() = javaResource.aadClaimsAuthorization().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Login parameters to send to the OpenID Connect authorization endpoint when
     * a user logs in. Each parameter must be in the form "key=value".
     */
    public val additionalLoginParams: Output<List<String>>?
        get() = javaResource.additionalLoginParams().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Allowed audience values to consider when validating JSON Web Tokens issued by
     * Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
     * allowed audience, regardless of this setting.
     */
    public val allowedAudiences: Output<List<String>>?
        get() = javaResource.allowedAudiences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
     * This is an advanced setting typically only needed by Windows Store application backends.
     * Note that URLs within the current domain are always implicitly allowed.
     */
    public val allowedExternalRedirectUrls: Output<List<String>>?
        get() = javaResource.allowedExternalRedirectUrls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The path of the config file containing auth settings.
     * If the path is relative, base will the site's root directory.
     */
    public val authFilePath: Output<String>?
        get() = javaResource.authFilePath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Client ID of this relying party application, known as the client_id.
     * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
     * other 3rd party OpenID Connect providers.
     * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
     */
    public val clientId: Output<String>?
        get() = javaResource.clientId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
     * This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
     * Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
     */
    public val clientSecret: Output<String>?
        get() = javaResource.clientSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
     * a replacement for the Client Secret. It is also optional.
     */
    public val clientSecretCertificateThumbprint: Output<String>?
        get() = javaResource.clientSecretCertificateThumbprint().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The app setting name that contains the client secret of the relying party application.
     */
    public val clientSecretSettingName: Output<String>?
        get() = javaResource.clientSecretSettingName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ConfigVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of the control plane for Authentication / Authorization.
     */
    public val configVersion: Output<String>?
        get() = javaResource.configVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default authentication provider to use when multiple providers are configured.
     * This setting is only needed if multiple providers are configured and the unauthenticated client
     * action is set to "RedirectToLoginPage".
     */
    public val defaultProvider: Output<String>?
        get() = javaResource.defaultProvider().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The App ID of the Facebook app used for login.
     * This setting is required for enabling Facebook Login.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    public val facebookAppId: Output<String>?
        get() = javaResource.facebookAppId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The App Secret of the Facebook app used for Facebook Login.
     * This setting is required for enabling Facebook Login.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    public val facebookAppSecret: Output<String>?
        get() = javaResource.facebookAppSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The app setting name that contains the app secret used for Facebook Login.
     */
    public val facebookAppSecretSettingName: Output<String>?
        get() = javaResource.facebookAppSecretSettingName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
     * This setting is optional.
     * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
     */
    public val facebookOAuthScopes: Output<List<String>>?
        get() = javaResource.facebookOAuthScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The Client Id of the GitHub app used for login.
     * This setting is required for enabling Github login
     */
    public val gitHubClientId: Output<String>?
        get() = javaResource.gitHubClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Client Secret of the GitHub app used for Github Login.
     * This setting is required for enabling Github login.
     */
    public val gitHubClientSecret: Output<String>?
        get() = javaResource.gitHubClientSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The app setting name that contains the client secret of the Github
     * app used for GitHub Login.
     */
    public val gitHubClientSecretSettingName: Output<String>?
        get() = javaResource.gitHubClientSecretSettingName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
     * This setting is optional
     */
    public val gitHubOAuthScopes: Output<List<String>>?
        get() = javaResource.gitHubOAuthScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The OpenID Connect Client ID for the Google web application.
     * This setting is required for enabling Google Sign-In.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    public val googleClientId: Output<String>?
        get() = javaResource.googleClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The client secret associated with the Google web application.
     * This setting is required for enabling Google Sign-In.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    public val googleClientSecret: Output<String>?
        get() = javaResource.googleClientSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The app setting name that contains the client secret associated with
     * the Google web application.
     */
    public val googleClientSecretSettingName: Output<String>?
        get() = javaResource.googleClientSecretSettingName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
     * This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
     * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
     */
    public val googleOAuthScopes: Output<List<String>>?
        get() = javaResource.googleOAuthScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * "true" if the auth config settings should be read from a file,
     * "false" otherwise
     */
    public val isAuthFromFile: Output<String>?
        get() = javaResource.isAuthFromFile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
     * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
     * This URI is a case-sensitive identifier for the token issuer.
     * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
     */
    public val issuer: Output<String>?
        get() = javaResource.issuer().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The OAuth 2.0 client ID that was created for the app used for authentication.
     * This setting is required for enabling Microsoft Account authentication.
     * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
     */
    public val microsoftAccountClientId: Output<String>?
        get() = javaResource.microsoftAccountClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OAuth 2.0 client secret that was created for the app used for authentication.
     * This setting is required for enabling Microsoft Account authentication.
     * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
     */
    public val microsoftAccountClientSecret: Output<String>?
        get() = javaResource.microsoftAccountClientSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The app setting name containing the OAuth 2.0 client secret that was created for the
     * app used for authentication.
     */
    public val microsoftAccountClientSecretSettingName: Output<String>?
        get() = javaResource.microsoftAccountClientSecretSettingName().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
     * This setting is optional. If not specified, "wl.basic" is used as the default scope.
     * Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
     */
    public val microsoftAccountOAuthScopes: Output<List<String>>?
        get() = javaResource.microsoftAccountOAuthScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
     * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
     */
    public val runtimeVersion: Output<String>?
        get() = javaResource.runtimeVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of hours after session token expiration that a session token can be used to
     * call the token refresh API. The default is 72 hours.
     */
    public val tokenRefreshExtensionHours: Output<Double>?
        get() = javaResource.tokenRefreshExtensionHours().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
     *  The default is <code>false</code>.
     */
    public val tokenStoreEnabled: Output<Boolean>?
        get() = javaResource.tokenStoreEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    public val twitterConsumerKey: Output<String>?
        get() = javaResource.twitterConsumerKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OAuth 1.0a consumer secret of the Twitter application used for sign-in.
     * This setting is required for enabling Twitter Sign-In.
     * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
     */
    public val twitterConsumerSecret: Output<String>?
        get() = javaResource.twitterConsumerSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
     * application used for sign-in.
     */
    public val twitterConsumerSecretSettingName: Output<String>?
        get() = javaResource.twitterConsumerSecretSettingName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The action to take when an unauthenticated client attempts to access the app.
     */
    public val unauthenticatedClientAction: Output<String>?
        get() = javaResource.unauthenticatedClientAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
     */
    public val validateIssuer: Output<Boolean>?
        get() = javaResource.validateIssuer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object WebAppAuthSettingsMapper : ResourceMapper<WebAppAuthSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppAuthSettings::class == javaResource::class

    override fun map(javaResource: Resource): WebAppAuthSettings = WebAppAuthSettings(
        javaResource as
            com.pulumi.azurenative.web.WebAppAuthSettings,
    )
}

/**
 * @see [WebAppAuthSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppAuthSettings].
 */
public suspend fun webAppAuthSettings(
    name: String,
    block: suspend WebAppAuthSettingsResourceBuilder.() -> Unit,
): WebAppAuthSettings {
    val builder = WebAppAuthSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppAuthSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppAuthSettings(name: String): WebAppAuthSettings {
    val builder = WebAppAuthSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
