@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.AzureStorageInfoValueResponse
import com.pulumi.azurenative.web.kotlin.outputs.AzureStorageInfoValueResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WebAppAzureStorageAccounts].
 */
@PulumiTagMarker
public class WebAppAzureStorageAccountsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppAzureStorageAccountsArgs = WebAppAzureStorageAccountsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppAzureStorageAccountsArgsBuilder.() -> Unit) {
        val builder = WebAppAzureStorageAccountsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppAzureStorageAccounts {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppAzureStorageAccounts(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppAzureStorageAccounts(builtJavaResource)
    }
}

/**
 * AzureStorageInfo dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Update Azure Storage Accounts
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppAzureStorageAccounts = new AzureNative.Web.WebAppAzureStorageAccounts("webAppAzureStorageAccounts", new()
 *     {
 *         Name = "sitef6141",
 *         Properties =
 *         {
 *             { "account1", new AzureNative.Web.Inputs.AzureStorageInfoValueArgs
 *             {
 *                 AccessKey = "26515^%@#*",
 *                 AccountName = "testsa",
 *                 MountPath = "/mounts/a/files",
 *                 ShareName = "web",
 *                 Type = AzureNative.Web.AzureStorageType.AzureFiles,
 *             } },
 *         },
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppAzureStorageAccounts(ctx, "webAppAzureStorageAccounts", &web.WebAppAzureStorageAccountsArgs{
 * 			Name: pulumi.String("sitef6141"),
 * 			Properties: web.AzureStorageInfoValueMap{
 * 				"account1": &web.AzureStorageInfoValueArgs{
 * 					AccessKey:   pulumi.String("26515^%@#*"),
 * 					AccountName: pulumi.String("testsa"),
 * 					MountPath:   pulumi.String("/mounts/a/files"),
 * 					ShareName:   pulumi.String("web"),
 * 					Type:        web.AzureStorageTypeAzureFiles,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppAzureStorageAccounts;
 * import com.pulumi.azurenative.web.WebAppAzureStorageAccountsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppAzureStorageAccounts = new WebAppAzureStorageAccounts("webAppAzureStorageAccounts", WebAppAzureStorageAccountsArgs.builder()
 *             .name("sitef6141")
 *             .properties(Map.of("account1", Map.ofEntries(
 *                 Map.entry("accessKey", "26515^%@#*"),
 *                 Map.entry("accountName", "testsa"),
 *                 Map.entry("mountPath", "/mounts/a/files"),
 *                 Map.entry("shareName", "web"),
 *                 Map.entry("type", "AzureFiles")
 *             )))
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppAzureStorageAccounts web /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts
 * ```
 */
public class WebAppAzureStorageAccounts internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppAzureStorageAccounts,
) : KotlinCustomResource(javaResource, WebAppAzureStorageAccountsMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure storage accounts.
     */
    public val properties: Output<Map<String, AzureStorageInfoValueResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> toKotlin(args0) }))
            }).toMap()
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppAzureStorageAccountsMapper : ResourceMapper<WebAppAzureStorageAccounts> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppAzureStorageAccounts::class == javaResource::class

    override fun map(javaResource: Resource): WebAppAzureStorageAccounts =
        WebAppAzureStorageAccounts(
            javaResource as
                com.pulumi.azurenative.web.WebAppAzureStorageAccounts,
        )
}

/**
 * @see [WebAppAzureStorageAccounts].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppAzureStorageAccounts].
 */
public suspend fun webAppAzureStorageAccounts(
    name: String,
    block: suspend WebAppAzureStorageAccountsResourceBuilder.() -> Unit,
):
    WebAppAzureStorageAccounts {
    val builder = WebAppAzureStorageAccountsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppAzureStorageAccounts].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppAzureStorageAccounts(name: String): WebAppAzureStorageAccounts {
    val builder = WebAppAzureStorageAccountsResourceBuilder()
    builder.name(name)
    return builder.build()
}
