@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppAzureStorageAccountsArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.AzureStorageInfoValueArgs
import com.pulumi.azurenative.web.kotlin.inputs.AzureStorageInfoValueArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * AzureStorageInfo dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Update Azure Storage Accounts
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppAzureStorageAccounts = new AzureNative.Web.WebAppAzureStorageAccounts("webAppAzureStorageAccounts", new()
 *     {
 *         Name = "sitef6141",
 *         Properties =
 *         {
 *             { "account1", new AzureNative.Web.Inputs.AzureStorageInfoValueArgs
 *             {
 *                 AccessKey = "26515^%@#*",
 *                 AccountName = "testsa",
 *                 MountPath = "/mounts/a/files",
 *                 ShareName = "web",
 *                 Type = AzureNative.Web.AzureStorageType.AzureFiles,
 *             } },
 *         },
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppAzureStorageAccounts(ctx, "webAppAzureStorageAccounts", &web.WebAppAzureStorageAccountsArgs{
 * 			Name: pulumi.String("sitef6141"),
 * 			Properties: web.AzureStorageInfoValueMap{
 * 				"account1": &web.AzureStorageInfoValueArgs{
 * 					AccessKey:   pulumi.String("26515^%@#*"),
 * 					AccountName: pulumi.String("testsa"),
 * 					MountPath:   pulumi.String("/mounts/a/files"),
 * 					ShareName:   pulumi.String("web"),
 * 					Type:        web.AzureStorageTypeAzureFiles,
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppAzureStorageAccounts;
 * import com.pulumi.azurenative.web.WebAppAzureStorageAccountsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppAzureStorageAccounts = new WebAppAzureStorageAccounts("webAppAzureStorageAccounts", WebAppAzureStorageAccountsArgs.builder()
 *             .name("sitef6141")
 *             .properties(Map.of("account1", Map.ofEntries(
 *                 Map.entry("accessKey", "26515^%@#*"),
 *                 Map.entry("accountName", "testsa"),
 *                 Map.entry("mountPath", "/mounts/a/files"),
 *                 Map.entry("shareName", "web"),
 *                 Map.entry("type", "AzureFiles")
 *             )))
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppAzureStorageAccounts web /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts
 * ```
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property properties Azure storage accounts.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class WebAppAzureStorageAccountsArgs(
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<Map<String, AzureStorageInfoValueArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppAzureStorageAccountsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppAzureStorageAccountsArgs =
        com.pulumi.azurenative.web.WebAppAzureStorageAccountsArgs.builder()
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppAzureStorageAccountsArgs].
 */
@PulumiTagMarker
public class WebAppAzureStorageAccountsArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<Map<String, AzureStorageInfoValueArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Kind of resource.
     */
    @JvmName("ucdjfltuawovyuty")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("rkbucdrkmyuxsbui")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure storage accounts.
     */
    @JvmName("aeunnwmqyltrdyus")
    public suspend fun properties(`value`: Output<Map<String, AzureStorageInfoValueArgs>>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("kvqusmqqacxlhdwa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("bxskotpujmluwkvo")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("xqlhyiqggjmilblr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Azure storage accounts.
     */
    @JvmName("iadcsboysmeeldmp")
    public suspend fun properties(`value`: Map<String, AzureStorageInfoValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Azure storage accounts.
     */
    @JvmName("lyehuruvuivghykt")
    public suspend fun properties(
        vararg
        argument: Pair<String, suspend AzureStorageInfoValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AzureStorageInfoValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param values Azure storage accounts.
     */
    @JvmName("drqwubkqvcrpqasc")
    public fun properties(vararg values: Pair<String, AzureStorageInfoValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("pgquiskiofsgttwt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppAzureStorageAccountsArgs = WebAppAzureStorageAccountsArgs(
        kind = kind,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
