@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppDeployment].
 */
@PulumiTagMarker
public class WebAppDeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppDeploymentArgs = WebAppDeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppDeploymentArgsBuilder.() -> Unit) {
        val builder = WebAppDeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppDeployment {
        val builtJavaResource = com.pulumi.azurenative.web.WebAppDeployment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAppDeployment(builtJavaResource)
    }
}

/**
 * User credentials used for publishing activity.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppDeployment myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}
 * ```
 */
public class WebAppDeployment internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppDeployment,
) : KotlinCustomResource(javaResource, WebAppDeploymentMapper) {
    /**
     * True if deployment is currently active, false if completed and null if not started.
     */
    public val active: Output<Boolean>?
        get() = javaResource.active().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Who authored the deployment.
     */
    public val author: Output<String>?
        get() = javaResource.author().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Author email.
     */
    public val authorEmail: Output<String>?
        get() = javaResource.authorEmail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Who performed the deployment.
     */
    public val deployer: Output<String>?
        get() = javaResource.deployer().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Details on deployment.
     */
    public val details: Output<String>?
        get() = javaResource.details().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * End time.
     */
    public val endTime: Output<String>?
        get() = javaResource.endTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Details about deployment status.
     */
    public val message: Output<String>?
        get() = javaResource.message().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Start time.
     */
    public val startTime: Output<String>?
        get() = javaResource.startTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Deployment status.
     */
    public val status: Output<Int>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppDeploymentMapper : ResourceMapper<WebAppDeployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppDeployment::class == javaResource::class

    override fun map(javaResource: Resource): WebAppDeployment = WebAppDeployment(
        javaResource as
            com.pulumi.azurenative.web.WebAppDeployment,
    )
}

/**
 * @see [WebAppDeployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppDeployment].
 */
public suspend fun webAppDeployment(
    name: String,
    block: suspend WebAppDeploymentResourceBuilder.() -> Unit,
): WebAppDeployment {
    val builder = WebAppDeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppDeployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppDeployment(name: String): WebAppDeployment {
    val builder = WebAppDeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
