@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User credentials used for publishing activity.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppDeployment myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}
 * ```
 * @property active True if deployment is currently active, false if completed and null if not started.
 * @property author Who authored the deployment.
 * @property authorEmail Author email.
 * @property deployer Who performed the deployment.
 * @property details Details on deployment.
 * @property endTime End time.
 * @property id ID of an existing deployment.
 * @property kind Kind of resource.
 * @property message Details about deployment status.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property startTime Start time.
 * @property status Deployment status.
 */
public data class WebAppDeploymentArgs(
    public val active: Output<Boolean>? = null,
    public val author: Output<String>? = null,
    public val authorEmail: Output<String>? = null,
    public val deployer: Output<String>? = null,
    public val details: Output<String>? = null,
    public val endTime: Output<String>? = null,
    public val id: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val message: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val status: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppDeploymentArgs =
        com.pulumi.azurenative.web.WebAppDeploymentArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .author(author?.applyValue({ args0 -> args0 }))
            .authorEmail(authorEmail?.applyValue({ args0 -> args0 }))
            .deployer(deployer?.applyValue({ args0 -> args0 }))
            .details(details?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppDeploymentArgs].
 */
@PulumiTagMarker
public class WebAppDeploymentArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var author: Output<String>? = null

    private var authorEmail: Output<String>? = null

    private var deployer: Output<String>? = null

    private var details: Output<String>? = null

    private var endTime: Output<String>? = null

    private var id: Output<String>? = null

    private var kind: Output<String>? = null

    private var message: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var startTime: Output<String>? = null

    private var status: Output<Int>? = null

    /**
     * @param value True if deployment is currently active, false if completed and null if not started.
     */
    @JvmName("rqfwgqinxduyiudj")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Who authored the deployment.
     */
    @JvmName("qmecktrltcasbltt")
    public suspend fun author(`value`: Output<String>) {
        this.author = value
    }

    /**
     * @param value Author email.
     */
    @JvmName("hgnnjlvocqldwgli")
    public suspend fun authorEmail(`value`: Output<String>) {
        this.authorEmail = value
    }

    /**
     * @param value Who performed the deployment.
     */
    @JvmName("nuydhosteymlrvyq")
    public suspend fun deployer(`value`: Output<String>) {
        this.deployer = value
    }

    /**
     * @param value Details on deployment.
     */
    @JvmName("nfnvtwfywnxelthg")
    public suspend fun details(`value`: Output<String>) {
        this.details = value
    }

    /**
     * @param value End time.
     */
    @JvmName("arxvkycwfjfcrvxt")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value ID of an existing deployment.
     */
    @JvmName("wwbadceokcekakia")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ghfdlnrqqclqxquj")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Details about deployment status.
     */
    @JvmName("smuxaxhaafridxtq")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("egivgtdmkvyhkjam")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("ctsrnrbegoeslmjc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Start time.
     */
    @JvmName("dopqsnoboudqbbil")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Deployment status.
     */
    @JvmName("nooxkdfebkhoykxp")
    public suspend fun status(`value`: Output<Int>) {
        this.status = value
    }

    /**
     * @param value True if deployment is currently active, false if completed and null if not started.
     */
    @JvmName("wnwjumbiepesbdpb")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Who authored the deployment.
     */
    @JvmName("vfikkajgimicdboe")
    public suspend fun author(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.author = mapped
    }

    /**
     * @param value Author email.
     */
    @JvmName("pyycvwlhuctisvul")
    public suspend fun authorEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorEmail = mapped
    }

    /**
     * @param value Who performed the deployment.
     */
    @JvmName("legxdxxibpktemlk")
    public suspend fun deployer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployer = mapped
    }

    /**
     * @param value Details on deployment.
     */
    @JvmName("tuaeownioffieesk")
    public suspend fun details(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param value End time.
     */
    @JvmName("neivpxfpnyoidepc")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value ID of an existing deployment.
     */
    @JvmName("pyvrmpnpynsmoabq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("fnsmiokshqoudtoq")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Details about deployment status.
     */
    @JvmName("lctpxnbqiglpabwj")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("qnpismmpdqxicrqk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("xfscpdcryocmqcnb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Start time.
     */
    @JvmName("exrnomnetndsajsv")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Deployment status.
     */
    @JvmName("dhbdpgssihdkjddd")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): WebAppDeploymentArgs = WebAppDeploymentArgs(
        active = active,
        author = author,
        authorEmail = authorEmail,
        deployer = deployer,
        details = details,
        endTime = endTime,
        id = id,
        kind = kind,
        message = message,
        name = name,
        resourceGroupName = resourceGroupName,
        startTime = startTime,
        status = status,
    )
}
