@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.kotlin.outputs.ApplicationLogsConfigResponse
import com.pulumi.azurenative.web.kotlin.outputs.EnabledConfigResponse
import com.pulumi.azurenative.web.kotlin.outputs.HttpLogsConfigResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.web.kotlin.outputs.ApplicationLogsConfigResponse.Companion.toKotlin as applicationLogsConfigResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.EnabledConfigResponse.Companion.toKotlin as enabledConfigResponseToKotlin
import com.pulumi.azurenative.web.kotlin.outputs.HttpLogsConfigResponse.Companion.toKotlin as httpLogsConfigResponseToKotlin

/**
 * Builder for [WebAppDiagnosticLogsConfiguration].
 */
@PulumiTagMarker
public class WebAppDiagnosticLogsConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppDiagnosticLogsConfigurationArgs = WebAppDiagnosticLogsConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppDiagnosticLogsConfigurationArgsBuilder.() -> Unit) {
        val builder = WebAppDiagnosticLogsConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppDiagnosticLogsConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppDiagnosticLogsConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppDiagnosticLogsConfiguration(builtJavaResource)
    }
}

/**
 * Configuration of App Service site logs.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppDiagnosticLogsConfiguration myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs
 * ```
 */
public class WebAppDiagnosticLogsConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppDiagnosticLogsConfiguration,
) : KotlinCustomResource(javaResource, WebAppDiagnosticLogsConfigurationMapper) {
    /**
     * Application logs configuration.
     */
    public val applicationLogs: Output<ApplicationLogsConfigResponse>?
        get() = javaResource.applicationLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationLogsConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Detailed error messages configuration.
     */
    public val detailedErrorMessages: Output<EnabledConfigResponse>?
        get() = javaResource.detailedErrorMessages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> enabledConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Failed requests tracing configuration.
     */
    public val failedRequestsTracing: Output<EnabledConfigResponse>?
        get() = javaResource.failedRequestsTracing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> enabledConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * HTTP logs configuration.
     */
    public val httpLogs: Output<HttpLogsConfigResponse>?
        get() = javaResource.httpLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    httpLogsConfigResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppDiagnosticLogsConfigurationMapper :
    ResourceMapper<WebAppDiagnosticLogsConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppDiagnosticLogsConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): WebAppDiagnosticLogsConfiguration =
        WebAppDiagnosticLogsConfiguration(
            javaResource as
                com.pulumi.azurenative.web.WebAppDiagnosticLogsConfiguration,
        )
}

/**
 * @see [WebAppDiagnosticLogsConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppDiagnosticLogsConfiguration].
 */
public suspend fun webAppDiagnosticLogsConfiguration(
    name: String,
    block: suspend WebAppDiagnosticLogsConfigurationResourceBuilder.() -> Unit,
):
    WebAppDiagnosticLogsConfiguration {
    val builder = WebAppDiagnosticLogsConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppDiagnosticLogsConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppDiagnosticLogsConfiguration(name: String): WebAppDiagnosticLogsConfiguration {
    val builder = WebAppDiagnosticLogsConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
