@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppDomainOwnershipIdentifier].
 */
@PulumiTagMarker
public class WebAppDomainOwnershipIdentifierResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppDomainOwnershipIdentifierArgs = WebAppDomainOwnershipIdentifierArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppDomainOwnershipIdentifierArgsBuilder.() -> Unit) {
        val builder = WebAppDomainOwnershipIdentifierArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppDomainOwnershipIdentifier {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifier(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppDomainOwnershipIdentifier(builtJavaResource)
    }
}

/**
 * A domain specific resource identifier.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2018-11-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppDomainOwnershipIdentifier myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}
 * ```
 */
public class WebAppDomainOwnershipIdentifier internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifier,
) : KotlinCustomResource(javaResource, WebAppDomainOwnershipIdentifierMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * String representation of the identity.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WebAppDomainOwnershipIdentifierMapper :
    ResourceMapper<WebAppDomainOwnershipIdentifier> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifier::class == javaResource::class

    override fun map(javaResource: Resource): WebAppDomainOwnershipIdentifier =
        WebAppDomainOwnershipIdentifier(
            javaResource as
                com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifier,
        )
}

/**
 * @see [WebAppDomainOwnershipIdentifier].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppDomainOwnershipIdentifier].
 */
public suspend fun webAppDomainOwnershipIdentifier(
    name: String,
    block: suspend WebAppDomainOwnershipIdentifierResourceBuilder.() -> Unit,
):
    WebAppDomainOwnershipIdentifier {
    val builder = WebAppDomainOwnershipIdentifierResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppDomainOwnershipIdentifier].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppDomainOwnershipIdentifier(name: String): WebAppDomainOwnershipIdentifier {
    val builder = WebAppDomainOwnershipIdentifierResourceBuilder()
    builder.name(name)
    return builder.build()
}
