@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppDomainOwnershipIdentifierSlot].
 */
@PulumiTagMarker
public class WebAppDomainOwnershipIdentifierSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppDomainOwnershipIdentifierSlotArgs =
        WebAppDomainOwnershipIdentifierSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend WebAppDomainOwnershipIdentifierSlotArgsBuilder.() -> Unit) {
        val builder = WebAppDomainOwnershipIdentifierSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppDomainOwnershipIdentifierSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppDomainOwnershipIdentifierSlot(builtJavaResource)
    }
}

/**
 * A domain specific resource identifier.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2018-11-01, 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppDomainOwnershipIdentifierSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}
 * ```
 */
public class WebAppDomainOwnershipIdentifierSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierSlot,
) : KotlinCustomResource(javaResource, WebAppDomainOwnershipIdentifierSlotMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * String representation of the identity.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WebAppDomainOwnershipIdentifierSlotMapper :
    ResourceMapper<WebAppDomainOwnershipIdentifierSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppDomainOwnershipIdentifierSlot =
        WebAppDomainOwnershipIdentifierSlot(
            javaResource as
                com.pulumi.azurenative.web.WebAppDomainOwnershipIdentifierSlot,
        )
}

/**
 * @see [WebAppDomainOwnershipIdentifierSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppDomainOwnershipIdentifierSlot].
 */
public suspend fun webAppDomainOwnershipIdentifierSlot(
    name: String,
    block: suspend WebAppDomainOwnershipIdentifierSlotResourceBuilder.() -> Unit,
):
    WebAppDomainOwnershipIdentifierSlot {
    val builder = WebAppDomainOwnershipIdentifierSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppDomainOwnershipIdentifierSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppDomainOwnershipIdentifierSlot(name: String): WebAppDomainOwnershipIdentifierSlot {
    val builder = WebAppDomainOwnershipIdentifierSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
