@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppHybridConnection].
 */
@PulumiTagMarker
public class WebAppHybridConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppHybridConnectionArgs = WebAppHybridConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppHybridConnectionArgsBuilder.() -> Unit) {
        val builder = WebAppHybridConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppHybridConnection {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppHybridConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppHybridConnection(builtJavaResource)
    }
}

/**
 * Hybrid Connection contract. This is used to configure a Hybrid Connection.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppHybridConnection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}
 * ```
 */
public class WebAppHybridConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppHybridConnection,
) : KotlinCustomResource(javaResource, WebAppHybridConnectionMapper) {
    /**
     * The hostname of the endpoint.
     */
    public val hostname: Output<String>?
        get() = javaResource.hostname().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The port of the endpoint.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ARM URI to the Service Bus relay.
     */
    public val relayArmUri: Output<String>?
        get() = javaResource.relayArmUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Service Bus relay.
     */
    public val relayName: Output<String>?
        get() = javaResource.relayName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
     */
    public val sendKeyName: Output<String>?
        get() = javaResource.sendKeyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned
     * normally, use the POST /listKeys API instead.
     */
    public val sendKeyValue: Output<String>?
        get() = javaResource.sendKeyValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Service Bus namespace.
     */
    public val serviceBusNamespace: Output<String>?
        get() = javaResource.serviceBusNamespace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The suffix for the service bus endpoint. By default this is .servicebus.windows.net
     */
    public val serviceBusSuffix: Output<String>?
        get() = javaResource.serviceBusSuffix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppHybridConnectionMapper : ResourceMapper<WebAppHybridConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppHybridConnection::class == javaResource::class

    override fun map(javaResource: Resource): WebAppHybridConnection =
        WebAppHybridConnection(javaResource as com.pulumi.azurenative.web.WebAppHybridConnection)
}

/**
 * @see [WebAppHybridConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppHybridConnection].
 */
public suspend fun webAppHybridConnection(
    name: String,
    block: suspend WebAppHybridConnectionResourceBuilder.() -> Unit,
): WebAppHybridConnection {
    val builder = WebAppHybridConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppHybridConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppHybridConnection(name: String): WebAppHybridConnection {
    val builder = WebAppHybridConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
