@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppHybridConnectionSlot].
 */
@PulumiTagMarker
public class WebAppHybridConnectionSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppHybridConnectionSlotArgs = WebAppHybridConnectionSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppHybridConnectionSlotArgsBuilder.() -> Unit) {
        val builder = WebAppHybridConnectionSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppHybridConnectionSlot {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppHybridConnectionSlot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppHybridConnectionSlot(builtJavaResource)
    }
}

/**
 * Hybrid Connection contract. This is used to configure a Hybrid Connection.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppHybridConnectionSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}
 * ```
 */
public class WebAppHybridConnectionSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppHybridConnectionSlot,
) : KotlinCustomResource(javaResource, WebAppHybridConnectionSlotMapper) {
    /**
     * The hostname of the endpoint.
     */
    public val hostname: Output<String>?
        get() = javaResource.hostname().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The port of the endpoint.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ARM URI to the Service Bus relay.
     */
    public val relayArmUri: Output<String>?
        get() = javaResource.relayArmUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Service Bus relay.
     */
    public val relayName: Output<String>?
        get() = javaResource.relayName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
     */
    public val sendKeyName: Output<String>?
        get() = javaResource.sendKeyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned
     * normally, use the POST /listKeys API instead.
     */
    public val sendKeyValue: Output<String>?
        get() = javaResource.sendKeyValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Service Bus namespace.
     */
    public val serviceBusNamespace: Output<String>?
        get() = javaResource.serviceBusNamespace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The suffix for the service bus endpoint. By default this is .servicebus.windows.net
     */
    public val serviceBusSuffix: Output<String>?
        get() = javaResource.serviceBusSuffix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppHybridConnectionSlotMapper : ResourceMapper<WebAppHybridConnectionSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppHybridConnectionSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppHybridConnectionSlot =
        WebAppHybridConnectionSlot(
            javaResource as
                com.pulumi.azurenative.web.WebAppHybridConnectionSlot,
        )
}

/**
 * @see [WebAppHybridConnectionSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppHybridConnectionSlot].
 */
public suspend fun webAppHybridConnectionSlot(
    name: String,
    block: suspend WebAppHybridConnectionSlotResourceBuilder.() -> Unit,
):
    WebAppHybridConnectionSlot {
    val builder = WebAppHybridConnectionSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppHybridConnectionSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppHybridConnectionSlot(name: String): WebAppHybridConnectionSlot {
    val builder = WebAppHybridConnectionSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
