@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WebAppMetadataSlot].
 */
@PulumiTagMarker
public class WebAppMetadataSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppMetadataSlotArgs = WebAppMetadataSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppMetadataSlotArgsBuilder.() -> Unit) {
        val builder = WebAppMetadataSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppMetadataSlot {
        val builtJavaResource = com.pulumi.azurenative.web.WebAppMetadataSlot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAppMetadataSlot(builtJavaResource)
    }
}

/**
 * String dictionary resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppMetadataSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata
 * ```
 */
public class WebAppMetadataSlot internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppMetadataSlot,
) : KotlinCustomResource(javaResource, WebAppMetadataSlotMapper) {
    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Settings.
     */
    public val properties: Output<Map<String, String>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppMetadataSlotMapper : ResourceMapper<WebAppMetadataSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppMetadataSlot::class == javaResource::class

    override fun map(javaResource: Resource): WebAppMetadataSlot = WebAppMetadataSlot(
        javaResource as
            com.pulumi.azurenative.web.WebAppMetadataSlot,
    )
}

/**
 * @see [WebAppMetadataSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppMetadataSlot].
 */
public suspend fun webAppMetadataSlot(
    name: String,
    block: suspend WebAppMetadataSlotResourceBuilder.() -> Unit,
): WebAppMetadataSlot {
    val builder = WebAppMetadataSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppMetadataSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppMetadataSlot(name: String): WebAppMetadataSlot {
    val builder = WebAppMetadataSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
