@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppPublicCertificate].
 */
@PulumiTagMarker
public class WebAppPublicCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppPublicCertificateArgs = WebAppPublicCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppPublicCertificateArgsBuilder.() -> Unit) {
        val builder = WebAppPublicCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppPublicCertificate {
        val builtJavaResource =
            com.pulumi.azurenative.web.WebAppPublicCertificate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppPublicCertificate(builtJavaResource)
    }
}

/**
 * Public certificate object
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppPublicCertificate myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}
 * ```
 */
public class WebAppPublicCertificate internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppPublicCertificate,
) : KotlinCustomResource(javaResource, WebAppPublicCertificateMapper) {
    /**
     * Public Certificate byte array
     */
    public val blob: Output<String>?
        get() = javaResource.blob().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Public Certificate Location
     */
    public val publicCertificateLocation: Output<String>?
        get() = javaResource.publicCertificateLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Certificate Thumbprint
     */
    public val thumbprint: Output<String>
        get() = javaResource.thumbprint().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppPublicCertificateMapper : ResourceMapper<WebAppPublicCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppPublicCertificate::class == javaResource::class

    override fun map(javaResource: Resource): WebAppPublicCertificate =
        WebAppPublicCertificate(javaResource as com.pulumi.azurenative.web.WebAppPublicCertificate)
}

/**
 * @see [WebAppPublicCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppPublicCertificate].
 */
public suspend fun webAppPublicCertificate(
    name: String,
    block: suspend WebAppPublicCertificateResourceBuilder.() -> Unit,
): WebAppPublicCertificate {
    val builder = WebAppPublicCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppPublicCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppPublicCertificate(name: String): WebAppPublicCertificate {
    val builder = WebAppPublicCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
