@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppPublicCertificateArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.PublicCertificateLocation
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Public certificate object
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppPublicCertificate myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}
 * ```
 * @property blob Public Certificate byte array
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property publicCertificateLocation Public Certificate Location
 * @property publicCertificateName Public certificate name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class WebAppPublicCertificateArgs(
    public val blob: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val publicCertificateLocation: Output<PublicCertificateLocation>? = null,
    public val publicCertificateName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppPublicCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppPublicCertificateArgs =
        com.pulumi.azurenative.web.WebAppPublicCertificateArgs.builder()
            .blob(blob?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .publicCertificateLocation(
                publicCertificateLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicCertificateName(publicCertificateName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppPublicCertificateArgs].
 */
@PulumiTagMarker
public class WebAppPublicCertificateArgsBuilder internal constructor() {
    private var blob: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var publicCertificateLocation: Output<PublicCertificateLocation>? = null

    private var publicCertificateName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Public Certificate byte array
     */
    @JvmName("urmjmvtpghyyenbc")
    public suspend fun blob(`value`: Output<String>) {
        this.blob = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ickfofvdeyhlqxio")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("papidltgndmaxkgs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Public Certificate Location
     */
    @JvmName("tfqyhuanbrhwmbgr")
    public suspend fun publicCertificateLocation(`value`: Output<PublicCertificateLocation>) {
        this.publicCertificateLocation = value
    }

    /**
     * @param value Public certificate name.
     */
    @JvmName("qpjmjpyhaebishbd")
    public suspend fun publicCertificateName(`value`: Output<String>) {
        this.publicCertificateName = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("nqxsvijbgqacekvg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Public Certificate byte array
     */
    @JvmName("umjltbnqjctdvolc")
    public suspend fun blob(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blob = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("jaxaewybulrtrfic")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("uippaykgefeabefh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Public Certificate Location
     */
    @JvmName("fnctdooppjjisysp")
    public suspend fun publicCertificateLocation(`value`: PublicCertificateLocation?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicCertificateLocation = mapped
    }

    /**
     * @param value Public certificate name.
     */
    @JvmName("xdqkgktyqyqlmmfo")
    public suspend fun publicCertificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicCertificateName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("yxycblkjambndcpe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppPublicCertificateArgs = WebAppPublicCertificateArgs(
        blob = blob,
        kind = kind,
        name = name,
        publicCertificateLocation = publicCertificateLocation,
        publicCertificateName = publicCertificateName,
        resourceGroupName = resourceGroupName,
    )
}
