@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppScmAllowed].
 */
@PulumiTagMarker
public class WebAppScmAllowedResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppScmAllowedArgs = WebAppScmAllowedArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppScmAllowedArgsBuilder.() -> Unit) {
        val builder = WebAppScmAllowedArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppScmAllowed {
        val builtJavaResource = com.pulumi.azurenative.web.WebAppScmAllowed(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAppScmAllowed(builtJavaResource)
    }
}

/**
 * Publishing Credentials Policies parameters.
 * Azure REST API version: 2022-09-01.
 * Other available API versions: 2019-08-01, 2020-06-01, 2020-09-01, 2020-10-01, 2020-12-01, 2021-01-01, 2021-01-15, 2021-02-01, 2021-03-01, 2022-03-01, 2023-01-01.
 * ## Example Usage
 * ### Update SCM Allowed
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppScmAllowed = new AzureNative.Web.WebAppScmAllowed("webAppScmAllowed", new()
 *     {
 *         Allow = true,
 *         Name = "testSite",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/web/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := web.NewWebAppScmAllowed(ctx, "webAppScmAllowed", &web.WebAppScmAllowedArgs{
 * 			Allow:             pulumi.Bool(true),
 * 			Name:              pulumi.String("testSite"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.web.WebAppScmAllowed;
 * import com.pulumi.azurenative.web.WebAppScmAllowedArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppScmAllowed = new WebAppScmAllowed("webAppScmAllowed", WebAppScmAllowedArgs.builder()
 *             .allow(true)
 *             .name("testSite")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppScmAllowed myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/scm
 * ```
 */
public class WebAppScmAllowed internal constructor(
    override val javaResource: com.pulumi.azurenative.web.WebAppScmAllowed,
) : KotlinCustomResource(javaResource, WebAppScmAllowedMapper) {
    /**
     * <code>true</code> to allow access to a publishing method; otherwise, <code>false</code>.
     */
    public val allow: Output<Boolean>
        get() = javaResource.allow().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppScmAllowedMapper : ResourceMapper<WebAppScmAllowed> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.web.WebAppScmAllowed::class == javaResource::class

    override fun map(javaResource: Resource): WebAppScmAllowed = WebAppScmAllowed(
        javaResource as
            com.pulumi.azurenative.web.WebAppScmAllowed,
    )
}

/**
 * @see [WebAppScmAllowed].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppScmAllowed].
 */
public suspend fun webAppScmAllowed(
    name: String,
    block: suspend WebAppScmAllowedResourceBuilder.() -> Unit,
): WebAppScmAllowed {
    val builder = WebAppScmAllowedResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppScmAllowed].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppScmAllowed(name: String): WebAppScmAllowed {
    val builder = WebAppScmAllowedResourceBuilder()
    builder.name(name)
    return builder.build()
}
