@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSlotConfigurationNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Slot Config names azure resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSlotConfigurationNames myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames
 * ```
 * @property appSettingNames List of application settings names.
 * @property azureStorageConfigNames List of external Azure storage account identifiers.
 * @property connectionStringNames List of connection string names.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class WebAppSlotConfigurationNamesArgs(
    public val appSettingNames: Output<List<String>>? = null,
    public val azureStorageConfigNames: Output<List<String>>? = null,
    public val connectionStringNames: Output<List<String>>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSlotConfigurationNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSlotConfigurationNamesArgs =
        com.pulumi.azurenative.web.WebAppSlotConfigurationNamesArgs.builder()
            .appSettingNames(appSettingNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .azureStorageConfigNames(
                azureStorageConfigNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .connectionStringNames(connectionStringNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSlotConfigurationNamesArgs].
 */
@PulumiTagMarker
public class WebAppSlotConfigurationNamesArgsBuilder internal constructor() {
    private var appSettingNames: Output<List<String>>? = null

    private var azureStorageConfigNames: Output<List<String>>? = null

    private var connectionStringNames: Output<List<String>>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value List of application settings names.
     */
    @JvmName("wlrfyvuwlaaehmdy")
    public suspend fun appSettingNames(`value`: Output<List<String>>) {
        this.appSettingNames = value
    }

    @JvmName("ywchvtrexkshbepx")
    public suspend fun appSettingNames(vararg values: Output<String>) {
        this.appSettingNames = Output.all(values.asList())
    }

    /**
     * @param values List of application settings names.
     */
    @JvmName("tcfjwnyiwnxtbabv")
    public suspend fun appSettingNames(values: List<Output<String>>) {
        this.appSettingNames = Output.all(values)
    }

    /**
     * @param value List of external Azure storage account identifiers.
     */
    @JvmName("oluyhsiijbedpury")
    public suspend fun azureStorageConfigNames(`value`: Output<List<String>>) {
        this.azureStorageConfigNames = value
    }

    @JvmName("lsabojcirgifnoej")
    public suspend fun azureStorageConfigNames(vararg values: Output<String>) {
        this.azureStorageConfigNames = Output.all(values.asList())
    }

    /**
     * @param values List of external Azure storage account identifiers.
     */
    @JvmName("fkihxjpsehahpgks")
    public suspend fun azureStorageConfigNames(values: List<Output<String>>) {
        this.azureStorageConfigNames = Output.all(values)
    }

    /**
     * @param value List of connection string names.
     */
    @JvmName("tmnojbhtxdnpmiby")
    public suspend fun connectionStringNames(`value`: Output<List<String>>) {
        this.connectionStringNames = value
    }

    @JvmName("tflqvxerirvlsurt")
    public suspend fun connectionStringNames(vararg values: Output<String>) {
        this.connectionStringNames = Output.all(values.asList())
    }

    /**
     * @param values List of connection string names.
     */
    @JvmName("jgxwikxiwuoowvjd")
    public suspend fun connectionStringNames(values: List<Output<String>>) {
        this.connectionStringNames = Output.all(values)
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("flyxhqtgcebslkqf")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("pbayyeawpwrhmnnr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("nsqtljxvurrfwhkb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of application settings names.
     */
    @JvmName("yblhurpwshueulqq")
    public suspend fun appSettingNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSettingNames = mapped
    }

    /**
     * @param values List of application settings names.
     */
    @JvmName("xvraoahrkrywrsyy")
    public suspend fun appSettingNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appSettingNames = mapped
    }

    /**
     * @param value List of external Azure storage account identifiers.
     */
    @JvmName("pijjhtswaidbvbve")
    public suspend fun azureStorageConfigNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureStorageConfigNames = mapped
    }

    /**
     * @param values List of external Azure storage account identifiers.
     */
    @JvmName("aqcmqixjkvnvccns")
    public suspend fun azureStorageConfigNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageConfigNames = mapped
    }

    /**
     * @param value List of connection string names.
     */
    @JvmName("sgmmdjaxcqhsplyy")
    public suspend fun connectionStringNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStringNames = mapped
    }

    /**
     * @param values List of connection string names.
     */
    @JvmName("xiklxdhsiiejutlm")
    public suspend fun connectionStringNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionStringNames = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("mdeyvmymkywiwxaj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("fareeutculqflrfg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("tmpomxwjjsyoabcg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): WebAppSlotConfigurationNamesArgs = WebAppSlotConfigurationNamesArgs(
        appSettingNames = appSettingNames,
        azureStorageConfigNames = azureStorageConfigNames,
        connectionStringNames = connectionStringNames,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
    )
}
