@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppSourceControlSlotArgs.builder
import com.pulumi.azurenative.web.kotlin.inputs.GitHubActionConfigurationArgs
import com.pulumi.azurenative.web.kotlin.inputs.GitHubActionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Source control configuration for an app.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppSourceControlSlot myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web
 * ```
 * @property branch Name of branch to use for deployment.
 * @property deploymentRollbackEnabled <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
 * @property gitHubActionConfiguration If GitHub Action is selected, than the associated configuration.
 * @property isGitHubAction <code>true</code> if this is deployed via GitHub action.
 * @property isManualIntegration <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
 * @property isMercurial <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property repoUrl Repository or source control URL.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot. If a slot is not specified, the API will update the source control configuration for the production slot.
 */
public data class WebAppSourceControlSlotArgs(
    public val branch: Output<String>? = null,
    public val deploymentRollbackEnabled: Output<Boolean>? = null,
    public val gitHubActionConfiguration: Output<GitHubActionConfigurationArgs>? = null,
    public val isGitHubAction: Output<Boolean>? = null,
    public val isManualIntegration: Output<Boolean>? = null,
    public val isMercurial: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val repoUrl: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val slot: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppSourceControlSlotArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppSourceControlSlotArgs =
        com.pulumi.azurenative.web.WebAppSourceControlSlotArgs.builder()
            .branch(branch?.applyValue({ args0 -> args0 }))
            .deploymentRollbackEnabled(deploymentRollbackEnabled?.applyValue({ args0 -> args0 }))
            .gitHubActionConfiguration(
                gitHubActionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .isGitHubAction(isGitHubAction?.applyValue({ args0 -> args0 }))
            .isManualIntegration(isManualIntegration?.applyValue({ args0 -> args0 }))
            .isMercurial(isMercurial?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .repoUrl(repoUrl?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .slot(slot?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppSourceControlSlotArgs].
 */
@PulumiTagMarker
public class WebAppSourceControlSlotArgsBuilder internal constructor() {
    private var branch: Output<String>? = null

    private var deploymentRollbackEnabled: Output<Boolean>? = null

    private var gitHubActionConfiguration: Output<GitHubActionConfigurationArgs>? = null

    private var isGitHubAction: Output<Boolean>? = null

    private var isManualIntegration: Output<Boolean>? = null

    private var isMercurial: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var repoUrl: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var slot: Output<String>? = null

    /**
     * @param value Name of branch to use for deployment.
     */
    @JvmName("eiqmixadgwnorfcl")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
     */
    @JvmName("npifqiyngwpyhjki")
    public suspend fun deploymentRollbackEnabled(`value`: Output<Boolean>) {
        this.deploymentRollbackEnabled = value
    }

    /**
     * @param value If GitHub Action is selected, than the associated configuration.
     */
    @JvmName("hgxfqowccadhymip")
    public suspend fun gitHubActionConfiguration(`value`: Output<GitHubActionConfigurationArgs>) {
        this.gitHubActionConfiguration = value
    }

    /**
     * @param value <code>true</code> if this is deployed via GitHub action.
     */
    @JvmName("hlmmjedwptncagoe")
    public suspend fun isGitHubAction(`value`: Output<Boolean>) {
        this.isGitHubAction = value
    }

    /**
     * @param value <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
     */
    @JvmName("nniecksuvexblnrg")
    public suspend fun isManualIntegration(`value`: Output<Boolean>) {
        this.isManualIntegration = value
    }

    /**
     * @param value <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
     */
    @JvmName("ybfyuufhqcguqxkm")
    public suspend fun isMercurial(`value`: Output<Boolean>) {
        this.isMercurial = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("pdwmoyfvqfqolsxb")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("ajcypkmdpxovpfrw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Repository or source control URL.
     */
    @JvmName("mebivxhfpkinfjsa")
    public suspend fun repoUrl(`value`: Output<String>) {
        this.repoUrl = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("jqfsrxyxdfyucdcw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the source control configuration for the production slot.
     */
    @JvmName("sdaftyevpdkfglio")
    public suspend fun slot(`value`: Output<String>) {
        this.slot = value
    }

    /**
     * @param value Name of branch to use for deployment.
     */
    @JvmName("xdxpysgjohlhkitg")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
     */
    @JvmName("xykdapsjxojfkyly")
    public suspend fun deploymentRollbackEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentRollbackEnabled = mapped
    }

    /**
     * @param value If GitHub Action is selected, than the associated configuration.
     */
    @JvmName("wqgaddmvmocgcnel")
    public suspend fun gitHubActionConfiguration(`value`: GitHubActionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHubActionConfiguration = mapped
    }

    /**
     * @param argument If GitHub Action is selected, than the associated configuration.
     */
    @JvmName("lkiqtmwpkhllreiw")
    public suspend
    fun gitHubActionConfiguration(argument: suspend GitHubActionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubActionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitHubActionConfiguration = mapped
    }

    /**
     * @param value <code>true</code> if this is deployed via GitHub action.
     */
    @JvmName("ahqolqtyrlmaabuv")
    public suspend fun isGitHubAction(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isGitHubAction = mapped
    }

    /**
     * @param value <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
     */
    @JvmName("iacrilutbditvqdd")
    public suspend fun isManualIntegration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isManualIntegration = mapped
    }

    /**
     * @param value <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
     */
    @JvmName("njsgemaoxfidnvym")
    public suspend fun isMercurial(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isMercurial = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("pkjygclvnvabqqlh")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("ihgmdkugibodcptc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Repository or source control URL.
     */
    @JvmName("gmwbqtsvxwrbruum")
    public suspend fun repoUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoUrl = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("wlitvvjctuvswgvo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API will update the source control configuration for the production slot.
     */
    @JvmName("toeipxynttrdqwup")
    public suspend fun slot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slot = mapped
    }

    internal fun build(): WebAppSourceControlSlotArgs = WebAppSourceControlSlotArgs(
        branch = branch,
        deploymentRollbackEnabled = deploymentRollbackEnabled,
        gitHubActionConfiguration = gitHubActionConfiguration,
        isGitHubAction = isGitHubAction,
        isManualIntegration = isManualIntegration,
        isMercurial = isMercurial,
        kind = kind,
        name = name,
        repoUrl = repoUrl,
        resourceGroupName = resourceGroupName,
        slot = slot,
    )
}
