@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin

import com.pulumi.azurenative.web.WebAppVnetConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Network information ARM resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:web:WebAppVnetConnection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}
 * ```
 * @property certBlob A certificate file (.cer) blob containing the public key of the private key used to authenticate a
 * Point-To-Site VPN connection.
 * @property dnsServers DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
 * @property isSwift Flag that is used to denote if this is VNET injection
 * @property kind Kind of resource.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property vnetName Name of an existing Virtual Network.
 * @property vnetResourceId The Virtual Network's resource ID.
 */
public data class WebAppVnetConnectionArgs(
    public val certBlob: Output<String>? = null,
    public val dnsServers: Output<String>? = null,
    public val isSwift: Output<Boolean>? = null,
    public val kind: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vnetName: Output<String>? = null,
    public val vnetResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.WebAppVnetConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.WebAppVnetConnectionArgs =
        com.pulumi.azurenative.web.WebAppVnetConnectionArgs.builder()
            .certBlob(certBlob?.applyValue({ args0 -> args0 }))
            .dnsServers(dnsServers?.applyValue({ args0 -> args0 }))
            .isSwift(isSwift?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vnetName(vnetName?.applyValue({ args0 -> args0 }))
            .vnetResourceId(vnetResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAppVnetConnectionArgs].
 */
@PulumiTagMarker
public class WebAppVnetConnectionArgsBuilder internal constructor() {
    private var certBlob: Output<String>? = null

    private var dnsServers: Output<String>? = null

    private var isSwift: Output<Boolean>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var vnetName: Output<String>? = null

    private var vnetResourceId: Output<String>? = null

    /**
     * @param value A certificate file (.cer) blob containing the public key of the private key used to authenticate a
     * Point-To-Site VPN connection.
     */
    @JvmName("npeqpydmqkqckugh")
    public suspend fun certBlob(`value`: Output<String>) {
        this.certBlob = value
    }

    /**
     * @param value DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
     */
    @JvmName("vupotiyywxsbgegy")
    public suspend fun dnsServers(`value`: Output<String>) {
        this.dnsServers = value
    }

    /**
     * @param value Flag that is used to denote if this is VNET injection
     */
    @JvmName("chifnkogaekqwjve")
    public suspend fun isSwift(`value`: Output<Boolean>) {
        this.isSwift = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("bxspkgrtxfqaegmj")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("mgkqtchctlmetdcd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("spiblvgtngfnomyy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of an existing Virtual Network.
     */
    @JvmName("wqbrbugcyqoogcvd")
    public suspend fun vnetName(`value`: Output<String>) {
        this.vnetName = value
    }

    /**
     * @param value The Virtual Network's resource ID.
     */
    @JvmName("wfejfrfmirrojpln")
    public suspend fun vnetResourceId(`value`: Output<String>) {
        this.vnetResourceId = value
    }

    /**
     * @param value A certificate file (.cer) blob containing the public key of the private key used to authenticate a
     * Point-To-Site VPN connection.
     */
    @JvmName("lwgddvuedmrsrdmy")
    public suspend fun certBlob(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certBlob = mapped
    }

    /**
     * @param value DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
     */
    @JvmName("spdgsgkfkywoftfk")
    public suspend fun dnsServers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Flag that is used to denote if this is VNET injection
     */
    @JvmName("senjsqgltdklkplg")
    public suspend fun isSwift(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSwift = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("iutpaerenpjxrxjh")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("fdpxtlnpavpvelqo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("phqcnjurvwppyiso")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of an existing Virtual Network.
     */
    @JvmName("bckxklylkosoqstu")
    public suspend fun vnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetName = mapped
    }

    /**
     * @param value The Virtual Network's resource ID.
     */
    @JvmName("mvbmomgbvysvkatu")
    public suspend fun vnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetResourceId = mapped
    }

    internal fun build(): WebAppVnetConnectionArgs = WebAppVnetConnectionArgs(
        certBlob = certBlob,
        dnsServers = dnsServers,
        isSwift = isSwift,
        kind = kind,
        name = name,
        resourceGroupName = resourceGroupName,
        vnetName = vnetName,
        vnetResourceId = vnetResourceId,
    )
}
