@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
 */
public enum class FrequencyUnit(
    public val javaValue: com.pulumi.azurenative.web.enums.FrequencyUnit,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.FrequencyUnit> {
    Day(com.pulumi.azurenative.web.enums.FrequencyUnit.Day),
    Hour(com.pulumi.azurenative.web.enums.FrequencyUnit.Hour),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.FrequencyUnit = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.FrequencyUnit): FrequencyUnit =
            FrequencyUnit.values().first { it.javaValue == javaType }
    }
}
