@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Log level.
 */
public enum class LogLevel(
    public val javaValue: com.pulumi.azurenative.web.enums.LogLevel,
) : ConvertibleToJava<com.pulumi.azurenative.web.enums.LogLevel> {
    Off(com.pulumi.azurenative.web.enums.LogLevel.Off),
    Verbose(com.pulumi.azurenative.web.enums.LogLevel.Verbose),
    Information(com.pulumi.azurenative.web.enums.LogLevel.Information),
    Warning(com.pulumi.azurenative.web.enums.LogLevel.Warning),
    Error(com.pulumi.azurenative.web.enums.LogLevel.Error),
    ;

    override fun toJava(): com.pulumi.azurenative.web.enums.LogLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.enums.LogLevel): LogLevel =
            LogLevel.values().first { it.javaValue == javaType }
    }
}
