@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AllowedPrincipalsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Azure Active Directory allowed principals.
 * @property groups The list of the allowed groups.
 * @property identities The list of the allowed identities.
 */
public data class AllowedPrincipalsArgs(
    public val groups: Output<List<String>>? = null,
    public val identities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AllowedPrincipalsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AllowedPrincipalsArgs =
        com.pulumi.azurenative.web.inputs.AllowedPrincipalsArgs.builder()
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .identities(identities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AllowedPrincipalsArgs].
 */
@PulumiTagMarker
public class AllowedPrincipalsArgsBuilder internal constructor() {
    private var groups: Output<List<String>>? = null

    private var identities: Output<List<String>>? = null

    /**
     * @param value The list of the allowed groups.
     */
    @JvmName("tmgadxunbcpiqfmf")
    public suspend fun groups(`value`: Output<List<String>>) {
        this.groups = value
    }

    @JvmName("otjmofdvvpsqiiwq")
    public suspend fun groups(vararg values: Output<String>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values The list of the allowed groups.
     */
    @JvmName("clsmtvjmlpijgdjc")
    public suspend fun groups(values: List<Output<String>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value The list of the allowed identities.
     */
    @JvmName("alevgjxkhdewoqoa")
    public suspend fun identities(`value`: Output<List<String>>) {
        this.identities = value
    }

    @JvmName("lyemgbtpmnpnmdgs")
    public suspend fun identities(vararg values: Output<String>) {
        this.identities = Output.all(values.asList())
    }

    /**
     * @param values The list of the allowed identities.
     */
    @JvmName("wgwyfjdeljbjdvrs")
    public suspend fun identities(values: List<Output<String>>) {
        this.identities = Output.all(values)
    }

    /**
     * @param value The list of the allowed groups.
     */
    @JvmName("bfexupyvscmannlg")
    public suspend fun groups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param values The list of the allowed groups.
     */
    @JvmName("lvcgdigjamxwcoil")
    public suspend fun groups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value The list of the allowed identities.
     */
    @JvmName("rpaurnkvyrlifdyb")
    public suspend fun identities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identities = mapped
    }

    /**
     * @param values The list of the allowed identities.
     */
    @JvmName("eocvoaxyyjudaldb")
    public suspend fun identities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identities = mapped
    }

    internal fun build(): AllowedPrincipalsArgs = AllowedPrincipalsArgs(
        groups = groups,
        identities = identities,
    )
}
