@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ApiResourceBackendServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The API backend service
 * @property serviceUrl The service URL
 */
public data class ApiResourceBackendServiceArgs(
    public val serviceUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ApiResourceBackendServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ApiResourceBackendServiceArgs =
        com.pulumi.azurenative.web.inputs.ApiResourceBackendServiceArgs.builder()
            .serviceUrl(serviceUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiResourceBackendServiceArgs].
 */
@PulumiTagMarker
public class ApiResourceBackendServiceArgsBuilder internal constructor() {
    private var serviceUrl: Output<String>? = null

    /**
     * @param value The service URL
     */
    @JvmName("emgwxdqcspfkmxfq")
    public suspend fun serviceUrl(`value`: Output<String>) {
        this.serviceUrl = value
    }

    /**
     * @param value The service URL
     */
    @JvmName("uxcxhubcjsgdhtpq")
    public suspend fun serviceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUrl = mapped
    }

    internal fun build(): ApiResourceBackendServiceArgs = ApiResourceBackendServiceArgs(
        serviceUrl = serviceUrl,
    )
}
