@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AppLogsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property destination
 * @property logAnalyticsConfiguration
 */
public data class AppLogsConfigurationArgs(
    public val destination: Output<String>? = null,
    public val logAnalyticsConfiguration: Output<LogAnalyticsConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AppLogsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AppLogsConfigurationArgs =
        com.pulumi.azurenative.web.inputs.AppLogsConfigurationArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .logAnalyticsConfiguration(
                logAnalyticsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AppLogsConfigurationArgs].
 */
@PulumiTagMarker
public class AppLogsConfigurationArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var logAnalyticsConfiguration: Output<LogAnalyticsConfigurationArgs>? = null

    /**
     * @param value
     */
    @JvmName("rlmxbkubgevswbps")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value
     */
    @JvmName("sjxplaiqnhsqsmna")
    public suspend fun logAnalyticsConfiguration(`value`: Output<LogAnalyticsConfigurationArgs>) {
        this.logAnalyticsConfiguration = value
    }

    /**
     * @param value
     */
    @JvmName("tibgaynppyayanyk")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value
     */
    @JvmName("jcraconopddplpnl")
    public suspend fun logAnalyticsConfiguration(`value`: LogAnalyticsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logAnalyticsConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ludxoybkhowbphkn")
    public suspend
    fun logAnalyticsConfiguration(argument: suspend LogAnalyticsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LogAnalyticsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logAnalyticsConfiguration = mapped
    }

    internal fun build(): AppLogsConfigurationArgs = AppLogsConfigurationArgs(
        destination = destination,
        logAnalyticsConfiguration = logAnalyticsConfiguration,
    )
}
