@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AseV3NetworkingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Full view of networking configuration for an ASE.
 * @property allowNewPrivateEndpointConnections Property to enable and disable new private endpoint connection creation on ASE
 * @property ftpEnabled Property to enable and disable FTP on ASEV3
 * @property inboundIpAddressOverride Customer provided Inbound IP Address. Only able to be set on Ase create.
 * @property kind Kind of resource.
 * @property remoteDebugEnabled Property to enable and disable Remote Debug on ASEV3
 */
public data class AseV3NetworkingConfigurationArgs(
    public val allowNewPrivateEndpointConnections: Output<Boolean>? = null,
    public val ftpEnabled: Output<Boolean>? = null,
    public val inboundIpAddressOverride: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val remoteDebugEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AseV3NetworkingConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AseV3NetworkingConfigurationArgs =
        com.pulumi.azurenative.web.inputs.AseV3NetworkingConfigurationArgs.builder()
            .allowNewPrivateEndpointConnections(
                allowNewPrivateEndpointConnections?.applyValue({ args0 ->
                    args0
                }),
            )
            .ftpEnabled(ftpEnabled?.applyValue({ args0 -> args0 }))
            .inboundIpAddressOverride(inboundIpAddressOverride?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .remoteDebugEnabled(remoteDebugEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AseV3NetworkingConfigurationArgs].
 */
@PulumiTagMarker
public class AseV3NetworkingConfigurationArgsBuilder internal constructor() {
    private var allowNewPrivateEndpointConnections: Output<Boolean>? = null

    private var ftpEnabled: Output<Boolean>? = null

    private var inboundIpAddressOverride: Output<String>? = null

    private var kind: Output<String>? = null

    private var remoteDebugEnabled: Output<Boolean>? = null

    /**
     * @param value Property to enable and disable new private endpoint connection creation on ASE
     */
    @JvmName("waxwrlcfpcaiwjts")
    public suspend fun allowNewPrivateEndpointConnections(`value`: Output<Boolean>) {
        this.allowNewPrivateEndpointConnections = value
    }

    /**
     * @param value Property to enable and disable FTP on ASEV3
     */
    @JvmName("jagnfwctsbtkneug")
    public suspend fun ftpEnabled(`value`: Output<Boolean>) {
        this.ftpEnabled = value
    }

    /**
     * @param value Customer provided Inbound IP Address. Only able to be set on Ase create.
     */
    @JvmName("kwvkwbulajdlxpcj")
    public suspend fun inboundIpAddressOverride(`value`: Output<String>) {
        this.inboundIpAddressOverride = value
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("ktuasflqilctjxms")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Property to enable and disable Remote Debug on ASEV3
     */
    @JvmName("ftelwvtbbakdnriq")
    public suspend fun remoteDebugEnabled(`value`: Output<Boolean>) {
        this.remoteDebugEnabled = value
    }

    /**
     * @param value Property to enable and disable new private endpoint connection creation on ASE
     */
    @JvmName("dpvhysxgiqorjnoa")
    public suspend fun allowNewPrivateEndpointConnections(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowNewPrivateEndpointConnections = mapped
    }

    /**
     * @param value Property to enable and disable FTP on ASEV3
     */
    @JvmName("sdoilybrpujlhjen")
    public suspend fun ftpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ftpEnabled = mapped
    }

    /**
     * @param value Customer provided Inbound IP Address. Only able to be set on Ase create.
     */
    @JvmName("scoybrnfaetnnyel")
    public suspend fun inboundIpAddressOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundIpAddressOverride = mapped
    }

    /**
     * @param value Kind of resource.
     */
    @JvmName("jqhbrvkxjaeatgbb")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Property to enable and disable Remote Debug on ASEV3
     */
    @JvmName("jmenwujgaeexfyce")
    public suspend fun remoteDebugEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDebugEnabled = mapped
    }

    internal fun build(): AseV3NetworkingConfigurationArgs = AseV3NetworkingConfigurationArgs(
        allowNewPrivateEndpointConnections = allowNewPrivateEndpointConnections,
        ftpEnabled = ftpEnabled,
        inboundIpAddressOverride = inboundIpAddressOverride,
        kind = kind,
        remoteDebugEnabled = remoteDebugEnabled,
    )
}
