@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AutoHealCustomActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Custom action to be executed
 * when an auto heal rule is triggered.
 * @property exe Executable to be run.
 * @property parameters Parameters for the executable.
 */
public data class AutoHealCustomActionArgs(
    public val exe: Output<String>? = null,
    public val parameters: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AutoHealCustomActionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AutoHealCustomActionArgs =
        com.pulumi.azurenative.web.inputs.AutoHealCustomActionArgs.builder()
            .exe(exe?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoHealCustomActionArgs].
 */
@PulumiTagMarker
public class AutoHealCustomActionArgsBuilder internal constructor() {
    private var exe: Output<String>? = null

    private var parameters: Output<String>? = null

    /**
     * @param value Executable to be run.
     */
    @JvmName("lpwbepyikcugyyfs")
    public suspend fun exe(`value`: Output<String>) {
        this.exe = value
    }

    /**
     * @param value Parameters for the executable.
     */
    @JvmName("qfxnibyvtfyvpfuv")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value Executable to be run.
     */
    @JvmName("prruxeqqrwjgphyl")
    public suspend fun exe(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exe = mapped
    }

    /**
     * @param value Parameters for the executable.
     */
    @JvmName("barqpwbnmyfspaoy")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): AutoHealCustomActionArgs = AutoHealCustomActionArgs(
        exe = exe,
        parameters = parameters,
    )
}
