@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.AzureStaticWebAppsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Azure Static Web Apps provider.
 * @property enabled <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
 * @property registration The configuration settings of the Azure Static Web Apps registration.
 */
public data class AzureStaticWebAppsArgs(
    public val enabled: Output<Boolean>? = null,
    public val registration: Output<AzureStaticWebAppsRegistrationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.AzureStaticWebAppsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.AzureStaticWebAppsArgs =
        com.pulumi.azurenative.web.inputs.AzureStaticWebAppsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AzureStaticWebAppsArgs].
 */
@PulumiTagMarker
public class AzureStaticWebAppsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var registration: Output<AzureStaticWebAppsRegistrationArgs>? = null

    /**
     * @param value <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("srvplbmcxhmhxftp")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The configuration settings of the Azure Static Web Apps registration.
     */
    @JvmName("qkcdvwctmagowusm")
    public suspend fun registration(`value`: Output<AzureStaticWebAppsRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
     */
    @JvmName("hqglbqbxfoqigkvy")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The configuration settings of the Azure Static Web Apps registration.
     */
    @JvmName("wcmhvwrikdxrcsbs")
    public suspend fun registration(`value`: AzureStaticWebAppsRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument The configuration settings of the Azure Static Web Apps registration.
     */
    @JvmName("ciqibpvmgxqhwwux")
    public suspend
    fun registration(argument: suspend AzureStaticWebAppsRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = AzureStaticWebAppsRegistrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    internal fun build(): AzureStaticWebAppsArgs = AzureStaticWebAppsArgs(
        enabled = enabled,
        registration = registration,
    )
}
