@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.DaprArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App Dapr configuration.
 * @property appId Dapr application identifier
 * @property appPort Port on which the Dapr side car
 * @property components Collection of Dapr components
 * @property enabled Boolean indicating if the Dapr side car is enabled
 */
public data class DaprArgs(
    public val appId: Output<String>? = null,
    public val appPort: Output<Int>? = null,
    public val components: Output<List<DaprComponentArgs>>? = null,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.DaprArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.DaprArgs =
        com.pulumi.azurenative.web.inputs.DaprArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .appPort(appPort?.applyValue({ args0 -> args0 }))
            .components(
                components?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprArgs].
 */
@PulumiTagMarker
public class DaprArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appPort: Output<Int>? = null

    private var components: Output<List<DaprComponentArgs>>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Dapr application identifier
     */
    @JvmName("gphmjupaqjxskitv")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Port on which the Dapr side car
     */
    @JvmName("ehbeduptbrlxgouv")
    public suspend fun appPort(`value`: Output<Int>) {
        this.appPort = value
    }

    /**
     * @param value Collection of Dapr components
     */
    @JvmName("wghmrfwtieljxqka")
    public suspend fun components(`value`: Output<List<DaprComponentArgs>>) {
        this.components = value
    }

    @JvmName("kscbsguixsogatah")
    public suspend fun components(vararg values: Output<DaprComponentArgs>) {
        this.components = Output.all(values.asList())
    }

    /**
     * @param values Collection of Dapr components
     */
    @JvmName("nyugdvgxqbkenwqo")
    public suspend fun components(values: List<Output<DaprComponentArgs>>) {
        this.components = Output.all(values)
    }

    /**
     * @param value Boolean indicating if the Dapr side car is enabled
     */
    @JvmName("hhbbfnancpxmckye")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Dapr application identifier
     */
    @JvmName("dxluropwvswtjuub")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Port on which the Dapr side car
     */
    @JvmName("buojxceupeayxkdm")
    public suspend fun appPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appPort = mapped
    }

    /**
     * @param value Collection of Dapr components
     */
    @JvmName("mfpbjuraeneiwasp")
    public suspend fun components(`value`: List<DaprComponentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param argument Collection of Dapr components
     */
    @JvmName("pioyqokwidcgyxto")
    public suspend fun components(argument: List<suspend DaprComponentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DaprComponentArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument Collection of Dapr components
     */
    @JvmName("opnclbvlgyxwsgup")
    public suspend fun components(vararg argument: suspend DaprComponentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DaprComponentArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument Collection of Dapr components
     */
    @JvmName("idrtmujbvhprnviq")
    public suspend fun components(argument: suspend DaprComponentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DaprComponentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param values Collection of Dapr components
     */
    @JvmName("fcgtuobbgkhchlpf")
    public suspend fun components(vararg values: DaprComponentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param value Boolean indicating if the Dapr side car is enabled
     */
    @JvmName("ybmxdmsuurjufylf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DaprArgs = DaprArgs(
        appId = appId,
        appPort = appPort,
        components = components,
        enabled = enabled,
    )
}
