@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.DaprMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container App Dapr component metadata.
 * @property name Metadata property name.
 * @property secretRef Name of the Container App secret from which to pull the metadata property value.
 * @property value Metadata property value.
 */
public data class DaprMetadataArgs(
    public val name: Output<String>? = null,
    public val secretRef: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.DaprMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.DaprMetadataArgs =
        com.pulumi.azurenative.web.inputs.DaprMetadataArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .secretRef(secretRef?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprMetadataArgs].
 */
@PulumiTagMarker
public class DaprMetadataArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secretRef: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Metadata property name.
     */
    @JvmName("twbtlfhkivobxkmu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the Container App secret from which to pull the metadata property value.
     */
    @JvmName("qtnndlbghhxpqyys")
    public suspend fun secretRef(`value`: Output<String>) {
        this.secretRef = value
    }

    /**
     * @param value Metadata property value.
     */
    @JvmName("tcbqdlseixdopdun")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Metadata property name.
     */
    @JvmName("ejntfobustosccwj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the Container App secret from which to pull the metadata property value.
     */
    @JvmName("qabvourafvkonjfi")
    public suspend fun secretRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretRef = mapped
    }

    /**
     * @param value Metadata property value.
     */
    @JvmName("iywoadhpvlhpewls")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DaprMetadataArgs = DaprMetadataArgs(
        name = name,
        secretRef = secretRef,
        `value` = `value`,
    )
}
