@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ExperimentsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Routing rules in production experiments.
 * @property rampUpRules List of ramp-up rules.
 */
public data class ExperimentsArgs(
    public val rampUpRules: Output<List<RampUpRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ExperimentsArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ExperimentsArgs =
        com.pulumi.azurenative.web.inputs.ExperimentsArgs.builder()
            .rampUpRules(
                rampUpRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExperimentsArgs].
 */
@PulumiTagMarker
public class ExperimentsArgsBuilder internal constructor() {
    private var rampUpRules: Output<List<RampUpRuleArgs>>? = null

    /**
     * @param value List of ramp-up rules.
     */
    @JvmName("dgumcqyhbyuxytvk")
    public suspend fun rampUpRules(`value`: Output<List<RampUpRuleArgs>>) {
        this.rampUpRules = value
    }

    @JvmName("gyeemiwcmgppngnx")
    public suspend fun rampUpRules(vararg values: Output<RampUpRuleArgs>) {
        this.rampUpRules = Output.all(values.asList())
    }

    /**
     * @param values List of ramp-up rules.
     */
    @JvmName("mjsixogeiovauten")
    public suspend fun rampUpRules(values: List<Output<RampUpRuleArgs>>) {
        this.rampUpRules = Output.all(values)
    }

    /**
     * @param value List of ramp-up rules.
     */
    @JvmName("tlogilvawxapewit")
    public suspend fun rampUpRules(`value`: List<RampUpRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpRules = mapped
    }

    /**
     * @param argument List of ramp-up rules.
     */
    @JvmName("naglexvxbohhuirf")
    public suspend fun rampUpRules(argument: List<suspend RampUpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RampUpRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rampUpRules = mapped
    }

    /**
     * @param argument List of ramp-up rules.
     */
    @JvmName("glslfcjirakgmrjh")
    public suspend fun rampUpRules(vararg argument: suspend RampUpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RampUpRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rampUpRules = mapped
    }

    /**
     * @param argument List of ramp-up rules.
     */
    @JvmName("sdkafrigqatjmifj")
    public suspend fun rampUpRules(argument: suspend RampUpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RampUpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rampUpRules = mapped
    }

    /**
     * @param values List of ramp-up rules.
     */
    @JvmName("pkgusjqylaajoewb")
    public suspend fun rampUpRules(vararg values: RampUpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpRules = mapped
    }

    internal fun build(): ExperimentsArgs = ExperimentsArgs(
        rampUpRules = rampUpRules,
    )
}
