@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.FileSystemApplicationLogsConfigArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.LogLevel
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Application logs to file system configuration.
 * @property level Log level.
 */
public data class FileSystemApplicationLogsConfigArgs(
    public val level: Output<LogLevel>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.FileSystemApplicationLogsConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.FileSystemApplicationLogsConfigArgs =
        com.pulumi.azurenative.web.inputs.FileSystemApplicationLogsConfigArgs.builder()
            .level(level?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FileSystemApplicationLogsConfigArgs].
 */
@PulumiTagMarker
public class FileSystemApplicationLogsConfigArgsBuilder internal constructor() {
    private var level: Output<LogLevel>? = null

    /**
     * @param value Log level.
     */
    @JvmName("lcdryawdwgkohahx")
    public suspend fun level(`value`: Output<LogLevel>) {
        this.level = value
    }

    /**
     * @param value Log level.
     */
    @JvmName("divwuyndlrfofxdq")
    public suspend fun level(`value`: LogLevel?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    internal fun build(): FileSystemApplicationLogsConfigArgs = FileSystemApplicationLogsConfigArgs(
        level = level,
    )
}
