@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppDomainOwnershipIdentifierPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainOwnershipIdentifierName Name of domain ownership identifier.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppDomainOwnershipIdentifierPlainArgs(
    public val domainOwnershipIdentifierName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppDomainOwnershipIdentifierPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.web.inputs.GetWebAppDomainOwnershipIdentifierPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppDomainOwnershipIdentifierPlainArgs.builder()
            .domainOwnershipIdentifierName(domainOwnershipIdentifierName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppDomainOwnershipIdentifierPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppDomainOwnershipIdentifierPlainArgsBuilder internal constructor() {
    private var domainOwnershipIdentifierName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of domain ownership identifier.
     */
    @JvmName("epykamhrsfsvcaxa")
    public suspend fun domainOwnershipIdentifierName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainOwnershipIdentifierName = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("fehonqqpwqnovkju")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("dbxvntsayrpuucur")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppDomainOwnershipIdentifierPlainArgs =
        GetWebAppDomainOwnershipIdentifierPlainArgs(
            domainOwnershipIdentifierName = domainOwnershipIdentifierName ?: throw
                PulumiNullFieldException("domainOwnershipIdentifierName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
