@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppHostNameBindingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostName Hostname in the hostname binding.
 * @property name Name of the app.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppHostNameBindingPlainArgs(
    public val hostName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppHostNameBindingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppHostNameBindingPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppHostNameBindingPlainArgs.builder()
            .hostName(hostName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppHostNameBindingPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppHostNameBindingPlainArgsBuilder internal constructor() {
    private var hostName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Hostname in the hostname binding.
     */
    @JvmName("bexeiyhrnkdnmwah")
    public suspend fun hostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostName = mapped
    }

    /**
     * @param value Name of the app.
     */
    @JvmName("repqesxtxgcaiakb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("montanyxeetttqka")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppHostNameBindingPlainArgs = GetWebAppHostNameBindingPlainArgs(
        hostName = hostName ?: throw PulumiNullFieldException("hostName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
