@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppPremierAddOnPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property premierAddOnName Add-on name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppPremierAddOnPlainArgs(
    public val name: String,
    public val premierAddOnName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppPremierAddOnPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppPremierAddOnPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppPremierAddOnPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .premierAddOnName(premierAddOnName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppPremierAddOnPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppPremierAddOnPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var premierAddOnName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("fdgisvynasjfggaw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Add-on name.
     */
    @JvmName("mupwnbvqyxvjesku")
    public suspend fun premierAddOnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.premierAddOnName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bpcohgoxkswmikqa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppPremierAddOnPlainArgs = GetWebAppPremierAddOnPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        premierAddOnName = premierAddOnName ?: throw PulumiNullFieldException("premierAddOnName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
