@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppPublicCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the app.
 * @property publicCertificateName Public certificate name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetWebAppPublicCertificatePlainArgs(
    public val name: String,
    public val publicCertificateName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppPublicCertificatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppPublicCertificatePlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppPublicCertificatePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .publicCertificateName(publicCertificateName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppPublicCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetWebAppPublicCertificatePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var publicCertificateName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the app.
     */
    @JvmName("ikjmoxsuvkpymusw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Public certificate name.
     */
    @JvmName("xqawdcehyoxypclo")
    public suspend fun publicCertificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publicCertificateName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("teuiyvywxgfcpdhm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWebAppPublicCertificatePlainArgs = GetWebAppPublicCertificatePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        publicCertificateName = publicCertificateName ?: throw
            PulumiNullFieldException("publicCertificateName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
