@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.GetWebAppSiteExtensionSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property siteExtensionId Site extension name.
 * @property slot Name of the deployment slot. If a slot is not specified, the API uses the production slot.
 */
public data class GetWebAppSiteExtensionSlotPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val siteExtensionId: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.GetWebAppSiteExtensionSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.GetWebAppSiteExtensionSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.GetWebAppSiteExtensionSlotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteExtensionId(siteExtensionId.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAppSiteExtensionSlotPlainArgs].
 */
@PulumiTagMarker
public class GetWebAppSiteExtensionSlotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var siteExtensionId: String? = null

    private var slot: String? = null

    /**
     * @param value Site name.
     */
    @JvmName("jrmagfnkbujuvnwl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("nufwmiiptoxhuayj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site extension name.
     */
    @JvmName("vfwfyadgshbapfol")
    public suspend fun siteExtensionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteExtensionId = mapped
    }

    /**
     * @param value Name of the deployment slot. If a slot is not specified, the API uses the production slot.
     */
    @JvmName("phefumknuasvdmeh")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): GetWebAppSiteExtensionSlotPlainArgs = GetWebAppSiteExtensionSlotPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteExtensionId = siteExtensionId ?: throw PulumiNullFieldException("siteExtensionId"),
        slot = slot ?: throw PulumiNullFieldException("slot"),
    )
}
