@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.HandlerMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The IIS handler mappings used to define which handler processes HTTP requests with certain extension.
 * For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.
 * @property arguments Command-line arguments to be passed to the script processor.
 * @property extension Requests with this extension will be handled using the specified FastCGI application.
 * @property scriptProcessor The absolute path to the FastCGI application.
 */
public data class HandlerMappingArgs(
    public val arguments: Output<String>? = null,
    public val extension: Output<String>? = null,
    public val scriptProcessor: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.HandlerMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.HandlerMappingArgs =
        com.pulumi.azurenative.web.inputs.HandlerMappingArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0 }))
            .extension(extension?.applyValue({ args0 -> args0 }))
            .scriptProcessor(scriptProcessor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HandlerMappingArgs].
 */
@PulumiTagMarker
public class HandlerMappingArgsBuilder internal constructor() {
    private var arguments: Output<String>? = null

    private var extension: Output<String>? = null

    private var scriptProcessor: Output<String>? = null

    /**
     * @param value Command-line arguments to be passed to the script processor.
     */
    @JvmName("ockwlkhdhajuampb")
    public suspend fun arguments(`value`: Output<String>) {
        this.arguments = value
    }

    /**
     * @param value Requests with this extension will be handled using the specified FastCGI application.
     */
    @JvmName("evkyamhxmvyfrumm")
    public suspend fun extension(`value`: Output<String>) {
        this.extension = value
    }

    /**
     * @param value The absolute path to the FastCGI application.
     */
    @JvmName("yhiiesxcpnevebgo")
    public suspend fun scriptProcessor(`value`: Output<String>) {
        this.scriptProcessor = value
    }

    /**
     * @param value Command-line arguments to be passed to the script processor.
     */
    @JvmName("bacvucdnfgruykar")
    public suspend fun arguments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Requests with this extension will be handled using the specified FastCGI application.
     */
    @JvmName("sfstenonxtxafxys")
    public suspend fun extension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extension = mapped
    }

    /**
     * @param value The absolute path to the FastCGI application.
     */
    @JvmName("vldtdypktdmqhygy")
    public suspend fun scriptProcessor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptProcessor = mapped
    }

    internal fun build(): HandlerMappingArgs = HandlerMappingArgs(
        arguments = arguments,
        extension = extension,
        scriptProcessor = scriptProcessor,
    )
}
