@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.ListWebAppFunctionSecretsSlotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property functionName Function name.
 * @property name Site name.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 * @property slot Name of the deployment slot.
 */
public data class ListWebAppFunctionSecretsSlotPlainArgs(
    public val functionName: String,
    public val name: String,
    public val resourceGroupName: String,
    public val slot: String,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.ListWebAppFunctionSecretsSlotPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.ListWebAppFunctionSecretsSlotPlainArgs =
        com.pulumi.azurenative.web.inputs.ListWebAppFunctionSecretsSlotPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .slot(slot.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWebAppFunctionSecretsSlotPlainArgs].
 */
@PulumiTagMarker
public class ListWebAppFunctionSecretsSlotPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    private var slot: String? = null

    /**
     * @param value Function name.
     */
    @JvmName("iqncfoujeidssymr")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("nmppxhkokaiotyxw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("bqqxvbbpcxdplvnm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the deployment slot.
     */
    @JvmName("wtpdsjmvmntsnlru")
    public suspend fun slot(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.slot = mapped
    }

    internal fun build(): ListWebAppFunctionSecretsSlotPlainArgs =
        ListWebAppFunctionSecretsSlotPlainArgs(
            functionName = functionName ?: throw PulumiNullFieldException("functionName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            slot = slot ?: throw PulumiNullFieldException("slot"),
        )
}
