@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.NameValuePairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Name value pair.
 * @property name Pair name.
 * @property value Pair value.
 */
public data class NameValuePairArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.NameValuePairArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.NameValuePairArgs =
        com.pulumi.azurenative.web.inputs.NameValuePairArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NameValuePairArgs].
 */
@PulumiTagMarker
public class NameValuePairArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Pair name.
     */
    @JvmName("mgogpbhlwrsaplbv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Pair value.
     */
    @JvmName("qrdpbhjmhkvxfgdi")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Pair name.
     */
    @JvmName("cjgxdkumckqsqjkk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Pair value.
     */
    @JvmName("rnygbuhugbiesbqy")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): NameValuePairArgs = NameValuePairArgs(
        name = name,
        `value` = `value`,
    )
}
