@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.NonceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the nonce used in the login flow.
 * @property nonceExpirationInterval The time after the request is made when the nonce should expire.
 * @property validateNonce <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
 */
public data class NonceArgs(
    public val nonceExpirationInterval: Output<String>? = null,
    public val validateNonce: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.NonceArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.NonceArgs =
        com.pulumi.azurenative.web.inputs.NonceArgs.builder()
            .nonceExpirationInterval(nonceExpirationInterval?.applyValue({ args0 -> args0 }))
            .validateNonce(validateNonce?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NonceArgs].
 */
@PulumiTagMarker
public class NonceArgsBuilder internal constructor() {
    private var nonceExpirationInterval: Output<String>? = null

    private var validateNonce: Output<Boolean>? = null

    /**
     * @param value The time after the request is made when the nonce should expire.
     */
    @JvmName("fwgmcqxmqjgdwffr")
    public suspend fun nonceExpirationInterval(`value`: Output<String>) {
        this.nonceExpirationInterval = value
    }

    /**
     * @param value <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
     */
    @JvmName("hollaxrjqcjjqrko")
    public suspend fun validateNonce(`value`: Output<Boolean>) {
        this.validateNonce = value
    }

    /**
     * @param value The time after the request is made when the nonce should expire.
     */
    @JvmName("voclhcvsktatvkrn")
    public suspend fun nonceExpirationInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonceExpirationInterval = mapped
    }

    /**
     * @param value <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
     */
    @JvmName("whibgwrroojgwnpd")
    public suspend fun validateNonce(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateNonce = mapped
    }

    internal fun build(): NonceArgs = NonceArgs(
        nonceExpirationInterval = nonceExpirationInterval,
        validateNonce = validateNonce,
    )
}
