@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.OpenIdConnectClientCredentialArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.ClientCredentialMethod
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The authentication client credentials of the custom Open ID Connect provider.
 * @property clientSecretSettingName The app setting that contains the client secret for the custom Open ID Connect provider.
 * @property method The method that should be used to authenticate the user.
 */
public data class OpenIdConnectClientCredentialArgs(
    public val clientSecretSettingName: Output<String>? = null,
    public val method: Output<ClientCredentialMethod>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.OpenIdConnectClientCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.OpenIdConnectClientCredentialArgs =
        com.pulumi.azurenative.web.inputs.OpenIdConnectClientCredentialArgs.builder()
            .clientSecretSettingName(clientSecretSettingName?.applyValue({ args0 -> args0 }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OpenIdConnectClientCredentialArgs].
 */
@PulumiTagMarker
public class OpenIdConnectClientCredentialArgsBuilder internal constructor() {
    private var clientSecretSettingName: Output<String>? = null

    private var method: Output<ClientCredentialMethod>? = null

    /**
     * @param value The app setting that contains the client secret for the custom Open ID Connect provider.
     */
    @JvmName("qhvdcsyghilnkhth")
    public suspend fun clientSecretSettingName(`value`: Output<String>) {
        this.clientSecretSettingName = value
    }

    /**
     * @param value The method that should be used to authenticate the user.
     */
    @JvmName("padchheftjfostgd")
    public suspend fun method(`value`: Output<ClientCredentialMethod>) {
        this.method = value
    }

    /**
     * @param value The app setting that contains the client secret for the custom Open ID Connect provider.
     */
    @JvmName("vpaeflqhfssolfnt")
    public suspend fun clientSecretSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecretSettingName = mapped
    }

    /**
     * @param value The method that should be used to authenticate the user.
     */
    @JvmName("ghymcwquljhhkjur")
    public suspend fun method(`value`: ClientCredentialMethod?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    internal fun build(): OpenIdConnectClientCredentialArgs = OpenIdConnectClientCredentialArgs(
        clientSecretSettingName = clientSecretSettingName,
        method = method,
    )
}
