@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.SiteConfigArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.DefaultAction
import com.pulumi.azurenative.web.kotlin.enums.FtpsState
import com.pulumi.azurenative.web.kotlin.enums.ManagedPipelineMode
import com.pulumi.azurenative.web.kotlin.enums.ScmType
import com.pulumi.azurenative.web.kotlin.enums.SiteLoadBalancing
import com.pulumi.azurenative.web.kotlin.enums.SupportedTlsVersions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Configuration of an App Service app.
 * @property acrUseManagedIdentityCreds Flag to use Managed Identity Creds for ACR pull
 * @property acrUserManagedIdentityID If using user managed identity, the user managed identity ClientId
 * @property alwaysOn <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
 * @property apiDefinition Information about the formal API definition for the app.
 * @property apiManagementConfig Azure API management settings linked to the app.
 * @property appCommandLine App command line to launch.
 * @property appSettings Application settings.
 * @property autoHealEnabled <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
 * @property autoHealRules Auto Heal rules.
 * @property autoSwapSlotName Auto-swap slot name.
 * @property azureStorageAccounts List of Azure Storage Accounts.
 * @property connectionStrings Connection strings.
 * @property cors Cross-Origin Resource Sharing (CORS) settings.
 * @property defaultDocuments Default documents.
 * @property detailedErrorLoggingEnabled <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
 * @property documentRoot Document root.
 * @property elasticWebAppScaleLimit Maximum number of workers that a site can scale out to.
 * This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
 * @property experiments This is work around for polymorphic types.
 * @property ftpsState State of FTP / FTPS service
 * @property functionAppScaleLimit Maximum number of workers that a site can scale out to.
 * This setting only applies to the Consumption and Elastic Premium Plans
 * @property functionsRuntimeScaleMonitoringEnabled Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
 * the ScaleController will not monitor event sources directly, but will instead call to the
 * runtime to get scale status.
 * @property handlerMappings Handler mappings.
 * @property healthCheckPath Health check path
 * @property http20Enabled Http20Enabled: configures a web site to allow clients to connect over http2.0
 * @property httpLoggingEnabled <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
 * @property ipSecurityRestrictions IP security restrictions for main.
 * @property ipSecurityRestrictionsDefaultAction Default action for main access restriction if no rules are matched.
 * @property javaContainer Java container.
 * @property javaContainerVersion Java container version.
 * @property javaVersion Java version.
 * @property keyVaultReferenceIdentity Identity to use for Key Vault Reference authentication.
 * @property limits Site limits.
 * @property linuxFxVersion Linux App Framework and version
 * @property loadBalancing Site load balancing.
 * @property localMySqlEnabled <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
 * @property logsDirectorySizeLimit HTTP logs directory size limit.
 * @property managedPipelineMode Managed pipeline mode.
 * @property managedServiceIdentityId Managed Service Identity Id
 * @property metadata Application metadata. This property cannot be retrieved, since it may contain secrets.
 * @property minTlsVersion MinTlsVersion: configures the minimum version of TLS required for SSL requests
 * @property minimumElasticInstanceCount Number of minimum instance count for a site
 * This setting only applies to the Elastic Plans
 * @property netFrameworkVersion .NET Framework version.
 * @property nodeVersion Version of Node.js.
 * @property numberOfWorkers Number of workers.
 * @property phpVersion Version of PHP.
 * @property powerShellVersion Version of PowerShell.
 * @property preWarmedInstanceCount Number of preWarmed instances.
 * This setting only applies to the Consumption and Elastic Plans
 * @property publicNetworkAccess Property to allow or block all public traffic.
 * @property publishingUsername Publishing user name.
 * @property push Push endpoint settings.
 * @property pythonVersion Version of Python.
 * @property remoteDebuggingEnabled <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
 * @property remoteDebuggingVersion Remote debugging version.
 * @property requestTracingEnabled <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
 * @property requestTracingExpirationTime Request tracing expiration time.
 * @property scmIpSecurityRestrictions IP security restrictions for scm.
 * @property scmIpSecurityRestrictionsDefaultAction Default action for scm access restriction if no rules are matched.
 * @property scmIpSecurityRestrictionsUseMain IP security restrictions for scm to use main.
 * @property scmMinTlsVersion ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
 * @property scmType SCM type.
 * @property tracingOptions Tracing options.
 * @property use32BitWorkerProcess <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
 * @property virtualApplications Virtual applications.
 * @property vnetName Virtual Network name.
 * @property vnetPrivatePortsCount The number of private ports assigned to this app. These will be assigned dynamically on runtime.
 * @property vnetRouteAllEnabled Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
 * @property webSocketsEnabled <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
 * @property websiteTimeZone Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
 * @property windowsFxVersion Xenon App Framework and version
 * @property xManagedServiceIdentityId Explicit Managed Service Identity Id
 */
public data class SiteConfigArgs(
    public val acrUseManagedIdentityCreds: Output<Boolean>? = null,
    public val acrUserManagedIdentityID: Output<String>? = null,
    public val alwaysOn: Output<Boolean>? = null,
    public val apiDefinition: Output<ApiDefinitionInfoArgs>? = null,
    public val apiManagementConfig: Output<ApiManagementConfigArgs>? = null,
    public val appCommandLine: Output<String>? = null,
    public val appSettings: Output<List<NameValuePairArgs>>? = null,
    public val autoHealEnabled: Output<Boolean>? = null,
    public val autoHealRules: Output<AutoHealRulesArgs>? = null,
    public val autoSwapSlotName: Output<String>? = null,
    public val azureStorageAccounts: Output<Map<String, AzureStorageInfoValueArgs>>? = null,
    public val connectionStrings: Output<List<ConnStringInfoArgs>>? = null,
    public val cors: Output<CorsSettingsArgs>? = null,
    public val defaultDocuments: Output<List<String>>? = null,
    public val detailedErrorLoggingEnabled: Output<Boolean>? = null,
    public val documentRoot: Output<String>? = null,
    public val elasticWebAppScaleLimit: Output<Int>? = null,
    public val experiments: Output<ExperimentsArgs>? = null,
    public val ftpsState: Output<Either<String, FtpsState>>? = null,
    public val functionAppScaleLimit: Output<Int>? = null,
    public val functionsRuntimeScaleMonitoringEnabled: Output<Boolean>? = null,
    public val handlerMappings: Output<List<HandlerMappingArgs>>? = null,
    public val healthCheckPath: Output<String>? = null,
    public val http20Enabled: Output<Boolean>? = null,
    public val httpLoggingEnabled: Output<Boolean>? = null,
    public val ipSecurityRestrictions: Output<List<IpSecurityRestrictionArgs>>? = null,
    public val ipSecurityRestrictionsDefaultAction: Output<Either<String, DefaultAction>>? = null,
    public val javaContainer: Output<String>? = null,
    public val javaContainerVersion: Output<String>? = null,
    public val javaVersion: Output<String>? = null,
    public val keyVaultReferenceIdentity: Output<String>? = null,
    public val limits: Output<SiteLimitsArgs>? = null,
    public val linuxFxVersion: Output<String>? = null,
    public val loadBalancing: Output<SiteLoadBalancing>? = null,
    public val localMySqlEnabled: Output<Boolean>? = null,
    public val logsDirectorySizeLimit: Output<Int>? = null,
    public val managedPipelineMode: Output<ManagedPipelineMode>? = null,
    public val managedServiceIdentityId: Output<Int>? = null,
    public val metadata: Output<List<NameValuePairArgs>>? = null,
    public val minTlsVersion: Output<Either<String, SupportedTlsVersions>>? = null,
    public val minimumElasticInstanceCount: Output<Int>? = null,
    public val netFrameworkVersion: Output<String>? = null,
    public val nodeVersion: Output<String>? = null,
    public val numberOfWorkers: Output<Int>? = null,
    public val phpVersion: Output<String>? = null,
    public val powerShellVersion: Output<String>? = null,
    public val preWarmedInstanceCount: Output<Int>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val publishingUsername: Output<String>? = null,
    public val push: Output<PushSettingsArgs>? = null,
    public val pythonVersion: Output<String>? = null,
    public val remoteDebuggingEnabled: Output<Boolean>? = null,
    public val remoteDebuggingVersion: Output<String>? = null,
    public val requestTracingEnabled: Output<Boolean>? = null,
    public val requestTracingExpirationTime: Output<String>? = null,
    public val scmIpSecurityRestrictions: Output<List<IpSecurityRestrictionArgs>>? = null,
    public val scmIpSecurityRestrictionsDefaultAction: Output<Either<String, DefaultAction>>? = null,
    public val scmIpSecurityRestrictionsUseMain: Output<Boolean>? = null,
    public val scmMinTlsVersion: Output<Either<String, SupportedTlsVersions>>? = null,
    public val scmType: Output<Either<String, ScmType>>? = null,
    public val tracingOptions: Output<String>? = null,
    public val use32BitWorkerProcess: Output<Boolean>? = null,
    public val virtualApplications: Output<List<VirtualApplicationArgs>>? = null,
    public val vnetName: Output<String>? = null,
    public val vnetPrivatePortsCount: Output<Int>? = null,
    public val vnetRouteAllEnabled: Output<Boolean>? = null,
    public val webSocketsEnabled: Output<Boolean>? = null,
    public val websiteTimeZone: Output<String>? = null,
    public val windowsFxVersion: Output<String>? = null,
    public val xManagedServiceIdentityId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.SiteConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.SiteConfigArgs =
        com.pulumi.azurenative.web.inputs.SiteConfigArgs.builder()
            .acrUseManagedIdentityCreds(acrUseManagedIdentityCreds?.applyValue({ args0 -> args0 }))
            .acrUserManagedIdentityID(acrUserManagedIdentityID?.applyValue({ args0 -> args0 }))
            .alwaysOn(alwaysOn?.applyValue({ args0 -> args0 }))
            .apiDefinition(apiDefinition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apiManagementConfig(
                apiManagementConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .appCommandLine(appCommandLine?.applyValue({ args0 -> args0 }))
            .appSettings(
                appSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .autoHealEnabled(autoHealEnabled?.applyValue({ args0 -> args0 }))
            .autoHealRules(autoHealRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoSwapSlotName(autoSwapSlotName?.applyValue({ args0 -> args0 }))
            .azureStorageAccounts(
                azureStorageAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .connectionStrings(
                connectionStrings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultDocuments(defaultDocuments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .detailedErrorLoggingEnabled(detailedErrorLoggingEnabled?.applyValue({ args0 -> args0 }))
            .documentRoot(documentRoot?.applyValue({ args0 -> args0 }))
            .elasticWebAppScaleLimit(elasticWebAppScaleLimit?.applyValue({ args0 -> args0 }))
            .experiments(experiments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ftpsState(
                ftpsState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .functionAppScaleLimit(functionAppScaleLimit?.applyValue({ args0 -> args0 }))
            .functionsRuntimeScaleMonitoringEnabled(
                functionsRuntimeScaleMonitoringEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .handlerMappings(
                handlerMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .healthCheckPath(healthCheckPath?.applyValue({ args0 -> args0 }))
            .http20Enabled(http20Enabled?.applyValue({ args0 -> args0 }))
            .httpLoggingEnabled(httpLoggingEnabled?.applyValue({ args0 -> args0 }))
            .ipSecurityRestrictions(
                ipSecurityRestrictions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipSecurityRestrictionsDefaultAction(
                ipSecurityRestrictionsDefaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .javaContainer(javaContainer?.applyValue({ args0 -> args0 }))
            .javaContainerVersion(javaContainerVersion?.applyValue({ args0 -> args0 }))
            .javaVersion(javaVersion?.applyValue({ args0 -> args0 }))
            .keyVaultReferenceIdentity(keyVaultReferenceIdentity?.applyValue({ args0 -> args0 }))
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linuxFxVersion(linuxFxVersion?.applyValue({ args0 -> args0 }))
            .loadBalancing(loadBalancing?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .localMySqlEnabled(localMySqlEnabled?.applyValue({ args0 -> args0 }))
            .logsDirectorySizeLimit(logsDirectorySizeLimit?.applyValue({ args0 -> args0 }))
            .managedPipelineMode(
                managedPipelineMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .managedServiceIdentityId(managedServiceIdentityId?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .minTlsVersion(
                minTlsVersion?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .minimumElasticInstanceCount(minimumElasticInstanceCount?.applyValue({ args0 -> args0 }))
            .netFrameworkVersion(netFrameworkVersion?.applyValue({ args0 -> args0 }))
            .nodeVersion(nodeVersion?.applyValue({ args0 -> args0 }))
            .numberOfWorkers(numberOfWorkers?.applyValue({ args0 -> args0 }))
            .phpVersion(phpVersion?.applyValue({ args0 -> args0 }))
            .powerShellVersion(powerShellVersion?.applyValue({ args0 -> args0 }))
            .preWarmedInstanceCount(preWarmedInstanceCount?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .publishingUsername(publishingUsername?.applyValue({ args0 -> args0 }))
            .push(push?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pythonVersion(pythonVersion?.applyValue({ args0 -> args0 }))
            .remoteDebuggingEnabled(remoteDebuggingEnabled?.applyValue({ args0 -> args0 }))
            .remoteDebuggingVersion(remoteDebuggingVersion?.applyValue({ args0 -> args0 }))
            .requestTracingEnabled(requestTracingEnabled?.applyValue({ args0 -> args0 }))
            .requestTracingExpirationTime(requestTracingExpirationTime?.applyValue({ args0 -> args0 }))
            .scmIpSecurityRestrictions(
                scmIpSecurityRestrictions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scmIpSecurityRestrictionsDefaultAction(
                scmIpSecurityRestrictionsDefaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .scmIpSecurityRestrictionsUseMain(scmIpSecurityRestrictionsUseMain?.applyValue({ args0 -> args0 }))
            .scmMinTlsVersion(
                scmMinTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .scmType(
                scmType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tracingOptions(tracingOptions?.applyValue({ args0 -> args0 }))
            .use32BitWorkerProcess(use32BitWorkerProcess?.applyValue({ args0 -> args0 }))
            .virtualApplications(
                virtualApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vnetName(vnetName?.applyValue({ args0 -> args0 }))
            .vnetPrivatePortsCount(vnetPrivatePortsCount?.applyValue({ args0 -> args0 }))
            .vnetRouteAllEnabled(vnetRouteAllEnabled?.applyValue({ args0 -> args0 }))
            .webSocketsEnabled(webSocketsEnabled?.applyValue({ args0 -> args0 }))
            .websiteTimeZone(websiteTimeZone?.applyValue({ args0 -> args0 }))
            .windowsFxVersion(windowsFxVersion?.applyValue({ args0 -> args0 }))
            .xManagedServiceIdentityId(xManagedServiceIdentityId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteConfigArgs].
 */
@PulumiTagMarker
public class SiteConfigArgsBuilder internal constructor() {
    private var acrUseManagedIdentityCreds: Output<Boolean>? = null

    private var acrUserManagedIdentityID: Output<String>? = null

    private var alwaysOn: Output<Boolean>? = null

    private var apiDefinition: Output<ApiDefinitionInfoArgs>? = null

    private var apiManagementConfig: Output<ApiManagementConfigArgs>? = null

    private var appCommandLine: Output<String>? = null

    private var appSettings: Output<List<NameValuePairArgs>>? = null

    private var autoHealEnabled: Output<Boolean>? = null

    private var autoHealRules: Output<AutoHealRulesArgs>? = null

    private var autoSwapSlotName: Output<String>? = null

    private var azureStorageAccounts: Output<Map<String, AzureStorageInfoValueArgs>>? = null

    private var connectionStrings: Output<List<ConnStringInfoArgs>>? = null

    private var cors: Output<CorsSettingsArgs>? = null

    private var defaultDocuments: Output<List<String>>? = null

    private var detailedErrorLoggingEnabled: Output<Boolean>? = null

    private var documentRoot: Output<String>? = null

    private var elasticWebAppScaleLimit: Output<Int>? = null

    private var experiments: Output<ExperimentsArgs>? = null

    private var ftpsState: Output<Either<String, FtpsState>>? = null

    private var functionAppScaleLimit: Output<Int>? = null

    private var functionsRuntimeScaleMonitoringEnabled: Output<Boolean>? = null

    private var handlerMappings: Output<List<HandlerMappingArgs>>? = null

    private var healthCheckPath: Output<String>? = null

    private var http20Enabled: Output<Boolean>? = null

    private var httpLoggingEnabled: Output<Boolean>? = null

    private var ipSecurityRestrictions: Output<List<IpSecurityRestrictionArgs>>? = null

    private var ipSecurityRestrictionsDefaultAction: Output<Either<String, DefaultAction>>? = null

    private var javaContainer: Output<String>? = null

    private var javaContainerVersion: Output<String>? = null

    private var javaVersion: Output<String>? = null

    private var keyVaultReferenceIdentity: Output<String>? = null

    private var limits: Output<SiteLimitsArgs>? = null

    private var linuxFxVersion: Output<String>? = null

    private var loadBalancing: Output<SiteLoadBalancing>? = null

    private var localMySqlEnabled: Output<Boolean>? = null

    private var logsDirectorySizeLimit: Output<Int>? = null

    private var managedPipelineMode: Output<ManagedPipelineMode>? = null

    private var managedServiceIdentityId: Output<Int>? = null

    private var metadata: Output<List<NameValuePairArgs>>? = null

    private var minTlsVersion: Output<Either<String, SupportedTlsVersions>>? = null

    private var minimumElasticInstanceCount: Output<Int>? = null

    private var netFrameworkVersion: Output<String>? = null

    private var nodeVersion: Output<String>? = null

    private var numberOfWorkers: Output<Int>? = null

    private var phpVersion: Output<String>? = null

    private var powerShellVersion: Output<String>? = null

    private var preWarmedInstanceCount: Output<Int>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var publishingUsername: Output<String>? = null

    private var push: Output<PushSettingsArgs>? = null

    private var pythonVersion: Output<String>? = null

    private var remoteDebuggingEnabled: Output<Boolean>? = null

    private var remoteDebuggingVersion: Output<String>? = null

    private var requestTracingEnabled: Output<Boolean>? = null

    private var requestTracingExpirationTime: Output<String>? = null

    private var scmIpSecurityRestrictions: Output<List<IpSecurityRestrictionArgs>>? = null

    private var scmIpSecurityRestrictionsDefaultAction: Output<Either<String, DefaultAction>>? = null

    private var scmIpSecurityRestrictionsUseMain: Output<Boolean>? = null

    private var scmMinTlsVersion: Output<Either<String, SupportedTlsVersions>>? = null

    private var scmType: Output<Either<String, ScmType>>? = null

    private var tracingOptions: Output<String>? = null

    private var use32BitWorkerProcess: Output<Boolean>? = null

    private var virtualApplications: Output<List<VirtualApplicationArgs>>? = null

    private var vnetName: Output<String>? = null

    private var vnetPrivatePortsCount: Output<Int>? = null

    private var vnetRouteAllEnabled: Output<Boolean>? = null

    private var webSocketsEnabled: Output<Boolean>? = null

    private var websiteTimeZone: Output<String>? = null

    private var windowsFxVersion: Output<String>? = null

    private var xManagedServiceIdentityId: Output<Int>? = null

    /**
     * @param value Flag to use Managed Identity Creds for ACR pull
     */
    @JvmName("brdlaqasdekgxlmo")
    public suspend fun acrUseManagedIdentityCreds(`value`: Output<Boolean>) {
        this.acrUseManagedIdentityCreds = value
    }

    /**
     * @param value If using user managed identity, the user managed identity ClientId
     */
    @JvmName("esxkpphibmoloitb")
    public suspend fun acrUserManagedIdentityID(`value`: Output<String>) {
        this.acrUserManagedIdentityID = value
    }

    /**
     * @param value <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
     */
    @JvmName("xylvhytoxfdfkuuv")
    public suspend fun alwaysOn(`value`: Output<Boolean>) {
        this.alwaysOn = value
    }

    /**
     * @param value Information about the formal API definition for the app.
     */
    @JvmName("gpciypvpcxpqdwcs")
    public suspend fun apiDefinition(`value`: Output<ApiDefinitionInfoArgs>) {
        this.apiDefinition = value
    }

    /**
     * @param value Azure API management settings linked to the app.
     */
    @JvmName("hefwykggfehilivk")
    public suspend fun apiManagementConfig(`value`: Output<ApiManagementConfigArgs>) {
        this.apiManagementConfig = value
    }

    /**
     * @param value App command line to launch.
     */
    @JvmName("yjxxduckrwxenxat")
    public suspend fun appCommandLine(`value`: Output<String>) {
        this.appCommandLine = value
    }

    /**
     * @param value Application settings.
     */
    @JvmName("lvtwbhmrxyhrymqu")
    public suspend fun appSettings(`value`: Output<List<NameValuePairArgs>>) {
        this.appSettings = value
    }

    @JvmName("phgijteuencjffbi")
    public suspend fun appSettings(vararg values: Output<NameValuePairArgs>) {
        this.appSettings = Output.all(values.asList())
    }

    /**
     * @param values Application settings.
     */
    @JvmName("qqhkvixiteuygkeh")
    public suspend fun appSettings(values: List<Output<NameValuePairArgs>>) {
        this.appSettings = Output.all(values)
    }

    /**
     * @param value <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
     */
    @JvmName("wsefiergiituchsd")
    public suspend fun autoHealEnabled(`value`: Output<Boolean>) {
        this.autoHealEnabled = value
    }

    /**
     * @param value Auto Heal rules.
     */
    @JvmName("ctyrwkbdruvxhlje")
    public suspend fun autoHealRules(`value`: Output<AutoHealRulesArgs>) {
        this.autoHealRules = value
    }

    /**
     * @param value Auto-swap slot name.
     */
    @JvmName("xkkvbiwbysethnck")
    public suspend fun autoSwapSlotName(`value`: Output<String>) {
        this.autoSwapSlotName = value
    }

    /**
     * @param value List of Azure Storage Accounts.
     */
    @JvmName("hywxfawtlhvuuwun")
    public suspend fun azureStorageAccounts(`value`: Output<Map<String, AzureStorageInfoValueArgs>>) {
        this.azureStorageAccounts = value
    }

    /**
     * @param value Connection strings.
     */
    @JvmName("pitqxogynsrvhwgw")
    public suspend fun connectionStrings(`value`: Output<List<ConnStringInfoArgs>>) {
        this.connectionStrings = value
    }

    @JvmName("lntrsjevgffajfvi")
    public suspend fun connectionStrings(vararg values: Output<ConnStringInfoArgs>) {
        this.connectionStrings = Output.all(values.asList())
    }

    /**
     * @param values Connection strings.
     */
    @JvmName("rynnltcbedphccdk")
    public suspend fun connectionStrings(values: List<Output<ConnStringInfoArgs>>) {
        this.connectionStrings = Output.all(values)
    }

    /**
     * @param value Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("vwujdlyeghvvanyf")
    public suspend fun cors(`value`: Output<CorsSettingsArgs>) {
        this.cors = value
    }

    /**
     * @param value Default documents.
     */
    @JvmName("qbpkaguinqhfplca")
    public suspend fun defaultDocuments(`value`: Output<List<String>>) {
        this.defaultDocuments = value
    }

    @JvmName("dqyuhxrirayynstf")
    public suspend fun defaultDocuments(vararg values: Output<String>) {
        this.defaultDocuments = Output.all(values.asList())
    }

    /**
     * @param values Default documents.
     */
    @JvmName("ljipbtvhcksagtxo")
    public suspend fun defaultDocuments(values: List<Output<String>>) {
        this.defaultDocuments = Output.all(values)
    }

    /**
     * @param value <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("xcmdlwsnlkhgxlvh")
    public suspend fun detailedErrorLoggingEnabled(`value`: Output<Boolean>) {
        this.detailedErrorLoggingEnabled = value
    }

    /**
     * @param value Document root.
     */
    @JvmName("twdpfdfdlgmohvfi")
    public suspend fun documentRoot(`value`: Output<String>) {
        this.documentRoot = value
    }

    /**
     * @param value Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
     */
    @JvmName("squiwtsngweppeta")
    public suspend fun elasticWebAppScaleLimit(`value`: Output<Int>) {
        this.elasticWebAppScaleLimit = value
    }

    /**
     * @param value This is work around for polymorphic types.
     */
    @JvmName("jyrwcmoovctawatc")
    public suspend fun experiments(`value`: Output<ExperimentsArgs>) {
        this.experiments = value
    }

    /**
     * @param value State of FTP / FTPS service
     */
    @JvmName("sqibylfgulbnqodw")
    public suspend fun ftpsState(`value`: Output<Either<String, FtpsState>>) {
        this.ftpsState = value
    }

    /**
     * @param value Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans
     */
    @JvmName("kdqvkfslqchoxvwv")
    public suspend fun functionAppScaleLimit(`value`: Output<Int>) {
        this.functionAppScaleLimit = value
    }

    /**
     * @param value Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     */
    @JvmName("gnrsedxgyxdejyps")
    public suspend fun functionsRuntimeScaleMonitoringEnabled(`value`: Output<Boolean>) {
        this.functionsRuntimeScaleMonitoringEnabled = value
    }

    /**
     * @param value Handler mappings.
     */
    @JvmName("gxqbapxmibjabcpi")
    public suspend fun handlerMappings(`value`: Output<List<HandlerMappingArgs>>) {
        this.handlerMappings = value
    }

    @JvmName("pjioaqamnwumyxaq")
    public suspend fun handlerMappings(vararg values: Output<HandlerMappingArgs>) {
        this.handlerMappings = Output.all(values.asList())
    }

    /**
     * @param values Handler mappings.
     */
    @JvmName("qfgfqanyixrdampe")
    public suspend fun handlerMappings(values: List<Output<HandlerMappingArgs>>) {
        this.handlerMappings = Output.all(values)
    }

    /**
     * @param value Health check path
     */
    @JvmName("acsrbnpeekmlchtq")
    public suspend fun healthCheckPath(`value`: Output<String>) {
        this.healthCheckPath = value
    }

    /**
     * @param value Http20Enabled: configures a web site to allow clients to connect over http2.0
     */
    @JvmName("xaoolgptxiwtiipa")
    public suspend fun http20Enabled(`value`: Output<Boolean>) {
        this.http20Enabled = value
    }

    /**
     * @param value <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("tbkhwmawsfxhfggf")
    public suspend fun httpLoggingEnabled(`value`: Output<Boolean>) {
        this.httpLoggingEnabled = value
    }

    /**
     * @param value IP security restrictions for main.
     */
    @JvmName("xdqaytxanmvvvivb")
    public suspend fun ipSecurityRestrictions(`value`: Output<List<IpSecurityRestrictionArgs>>) {
        this.ipSecurityRestrictions = value
    }

    @JvmName("btdvxnyapmrlmdsj")
    public suspend fun ipSecurityRestrictions(vararg values: Output<IpSecurityRestrictionArgs>) {
        this.ipSecurityRestrictions = Output.all(values.asList())
    }

    /**
     * @param values IP security restrictions for main.
     */
    @JvmName("ejqecqmaunagnsqu")
    public suspend fun ipSecurityRestrictions(values: List<Output<IpSecurityRestrictionArgs>>) {
        this.ipSecurityRestrictions = Output.all(values)
    }

    /**
     * @param value Default action for main access restriction if no rules are matched.
     */
    @JvmName("bhkhrfihsfpywxuf")
    public suspend
    fun ipSecurityRestrictionsDefaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.ipSecurityRestrictionsDefaultAction = value
    }

    /**
     * @param value Java container.
     */
    @JvmName("cpxlthoqstgxohbj")
    public suspend fun javaContainer(`value`: Output<String>) {
        this.javaContainer = value
    }

    /**
     * @param value Java container version.
     */
    @JvmName("cbbgucyqpolevwjp")
    public suspend fun javaContainerVersion(`value`: Output<String>) {
        this.javaContainerVersion = value
    }

    /**
     * @param value Java version.
     */
    @JvmName("bspemfpvwjxuaosk")
    public suspend fun javaVersion(`value`: Output<String>) {
        this.javaVersion = value
    }

    /**
     * @param value Identity to use for Key Vault Reference authentication.
     */
    @JvmName("catxeqqxxyonvnum")
    public suspend fun keyVaultReferenceIdentity(`value`: Output<String>) {
        this.keyVaultReferenceIdentity = value
    }

    /**
     * @param value Site limits.
     */
    @JvmName("poewbpyluyhevdtx")
    public suspend fun limits(`value`: Output<SiteLimitsArgs>) {
        this.limits = value
    }

    /**
     * @param value Linux App Framework and version
     */
    @JvmName("sayeebleutgkmusw")
    public suspend fun linuxFxVersion(`value`: Output<String>) {
        this.linuxFxVersion = value
    }

    /**
     * @param value Site load balancing.
     */
    @JvmName("lkvskkjbwyajibjy")
    public suspend fun loadBalancing(`value`: Output<SiteLoadBalancing>) {
        this.loadBalancing = value
    }

    /**
     * @param value <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
     */
    @JvmName("kffbwuptybrmacdu")
    public suspend fun localMySqlEnabled(`value`: Output<Boolean>) {
        this.localMySqlEnabled = value
    }

    /**
     * @param value HTTP logs directory size limit.
     */
    @JvmName("fgrxpfakeswygybl")
    public suspend fun logsDirectorySizeLimit(`value`: Output<Int>) {
        this.logsDirectorySizeLimit = value
    }

    /**
     * @param value Managed pipeline mode.
     */
    @JvmName("xmmlhwbsjvixdqjp")
    public suspend fun managedPipelineMode(`value`: Output<ManagedPipelineMode>) {
        this.managedPipelineMode = value
    }

    /**
     * @param value Managed Service Identity Id
     */
    @JvmName("eodbaeuxsnnewrqi")
    public suspend fun managedServiceIdentityId(`value`: Output<Int>) {
        this.managedServiceIdentityId = value
    }

    /**
     * @param value Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("gywwqqhdeybvjymu")
    public suspend fun metadata(`value`: Output<List<NameValuePairArgs>>) {
        this.metadata = value
    }

    @JvmName("wstxucslpnsudskr")
    public suspend fun metadata(vararg values: Output<NameValuePairArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("dgjhvhuqtvcyxqvp")
    public suspend fun metadata(values: List<Output<NameValuePairArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    @JvmName("dhgfalukexaemrus")
    public suspend fun minTlsVersion(`value`: Output<Either<String, SupportedTlsVersions>>) {
        this.minTlsVersion = value
    }

    /**
     * @param value Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans
     */
    @JvmName("yoytubkiwkogiohe")
    public suspend fun minimumElasticInstanceCount(`value`: Output<Int>) {
        this.minimumElasticInstanceCount = value
    }

    /**
     * @param value .NET Framework version.
     */
    @JvmName("qqyyxutocsjndtai")
    public suspend fun netFrameworkVersion(`value`: Output<String>) {
        this.netFrameworkVersion = value
    }

    /**
     * @param value Version of Node.js.
     */
    @JvmName("tamyvdlmcvxhcmgn")
    public suspend fun nodeVersion(`value`: Output<String>) {
        this.nodeVersion = value
    }

    /**
     * @param value Number of workers.
     */
    @JvmName("guobilmjntdfgovd")
    public suspend fun numberOfWorkers(`value`: Output<Int>) {
        this.numberOfWorkers = value
    }

    /**
     * @param value Version of PHP.
     */
    @JvmName("fbyyudjvsbagednd")
    public suspend fun phpVersion(`value`: Output<String>) {
        this.phpVersion = value
    }

    /**
     * @param value Version of PowerShell.
     */
    @JvmName("oomxanakdbfqqowl")
    public suspend fun powerShellVersion(`value`: Output<String>) {
        this.powerShellVersion = value
    }

    /**
     * @param value Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans
     */
    @JvmName("sacnvjsruvlcbtut")
    public suspend fun preWarmedInstanceCount(`value`: Output<Int>) {
        this.preWarmedInstanceCount = value
    }

    /**
     * @param value Property to allow or block all public traffic.
     */
    @JvmName("hvcevufrpakpectl")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Publishing user name.
     */
    @JvmName("xwovqlgyjagpynlo")
    public suspend fun publishingUsername(`value`: Output<String>) {
        this.publishingUsername = value
    }

    /**
     * @param value Push endpoint settings.
     */
    @JvmName("ajsrvmhfexicswya")
    public suspend fun push(`value`: Output<PushSettingsArgs>) {
        this.push = value
    }

    /**
     * @param value Version of Python.
     */
    @JvmName("ogphfdmojsreyble")
    public suspend fun pythonVersion(`value`: Output<String>) {
        this.pythonVersion = value
    }

    /**
     * @param value <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("xvkaitnolxwjsjtp")
    public suspend fun remoteDebuggingEnabled(`value`: Output<Boolean>) {
        this.remoteDebuggingEnabled = value
    }

    /**
     * @param value Remote debugging version.
     */
    @JvmName("wguwbanciqnokbor")
    public suspend fun remoteDebuggingVersion(`value`: Output<String>) {
        this.remoteDebuggingVersion = value
    }

    /**
     * @param value <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
     */
    @JvmName("istwertwqdloyudw")
    public suspend fun requestTracingEnabled(`value`: Output<Boolean>) {
        this.requestTracingEnabled = value
    }

    /**
     * @param value Request tracing expiration time.
     */
    @JvmName("vkjiuuuqkelmturq")
    public suspend fun requestTracingExpirationTime(`value`: Output<String>) {
        this.requestTracingExpirationTime = value
    }

    /**
     * @param value IP security restrictions for scm.
     */
    @JvmName("laefnwgjinxqnnpp")
    public suspend fun scmIpSecurityRestrictions(`value`: Output<List<IpSecurityRestrictionArgs>>) {
        this.scmIpSecurityRestrictions = value
    }

    @JvmName("mjhnldbfkerhreuo")
    public suspend fun scmIpSecurityRestrictions(vararg values: Output<IpSecurityRestrictionArgs>) {
        this.scmIpSecurityRestrictions = Output.all(values.asList())
    }

    /**
     * @param values IP security restrictions for scm.
     */
    @JvmName("qqaafmdvwjslndjx")
    public suspend fun scmIpSecurityRestrictions(values: List<Output<IpSecurityRestrictionArgs>>) {
        this.scmIpSecurityRestrictions = Output.all(values)
    }

    /**
     * @param value Default action for scm access restriction if no rules are matched.
     */
    @JvmName("wlkbxrtetcvemift")
    public suspend
    fun scmIpSecurityRestrictionsDefaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.scmIpSecurityRestrictionsDefaultAction = value
    }

    /**
     * @param value IP security restrictions for scm to use main.
     */
    @JvmName("shjxybkhjbriiicg")
    public suspend fun scmIpSecurityRestrictionsUseMain(`value`: Output<Boolean>) {
        this.scmIpSecurityRestrictionsUseMain = value
    }

    /**
     * @param value ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    @JvmName("bevidomlsdojvntt")
    public suspend fun scmMinTlsVersion(`value`: Output<Either<String, SupportedTlsVersions>>) {
        this.scmMinTlsVersion = value
    }

    /**
     * @param value SCM type.
     */
    @JvmName("iqlhnxfaxukosits")
    public suspend fun scmType(`value`: Output<Either<String, ScmType>>) {
        this.scmType = value
    }

    /**
     * @param value Tracing options.
     */
    @JvmName("kctksnqiitgpmypc")
    public suspend fun tracingOptions(`value`: Output<String>) {
        this.tracingOptions = value
    }

    /**
     * @param value <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
     */
    @JvmName("huhvgrkwjbsyjumx")
    public suspend fun use32BitWorkerProcess(`value`: Output<Boolean>) {
        this.use32BitWorkerProcess = value
    }

    /**
     * @param value Virtual applications.
     */
    @JvmName("oriohnnmobdwnbxa")
    public suspend fun virtualApplications(`value`: Output<List<VirtualApplicationArgs>>) {
        this.virtualApplications = value
    }

    @JvmName("jyetxaslxkeqnctb")
    public suspend fun virtualApplications(vararg values: Output<VirtualApplicationArgs>) {
        this.virtualApplications = Output.all(values.asList())
    }

    /**
     * @param values Virtual applications.
     */
    @JvmName("tkuybcmfxbctpkck")
    public suspend fun virtualApplications(values: List<Output<VirtualApplicationArgs>>) {
        this.virtualApplications = Output.all(values)
    }

    /**
     * @param value Virtual Network name.
     */
    @JvmName("cjlbjboadjoamiuo")
    public suspend fun vnetName(`value`: Output<String>) {
        this.vnetName = value
    }

    /**
     * @param value The number of private ports assigned to this app. These will be assigned dynamically on runtime.
     */
    @JvmName("ydmpbvkftylfwrqv")
    public suspend fun vnetPrivatePortsCount(`value`: Output<Int>) {
        this.vnetPrivatePortsCount = value
    }

    /**
     * @param value Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
     */
    @JvmName("iwycpqhayehwxgbg")
    public suspend fun vnetRouteAllEnabled(`value`: Output<Boolean>) {
        this.vnetRouteAllEnabled = value
    }

    /**
     * @param value <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
     */
    @JvmName("aycwfhtjwoiffoqx")
    public suspend fun webSocketsEnabled(`value`: Output<Boolean>) {
        this.webSocketsEnabled = value
    }

    /**
     * @param value Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
     */
    @JvmName("pdbgdbqnatxytial")
    public suspend fun websiteTimeZone(`value`: Output<String>) {
        this.websiteTimeZone = value
    }

    /**
     * @param value Xenon App Framework and version
     */
    @JvmName("chbkgxxrrwtyinqt")
    public suspend fun windowsFxVersion(`value`: Output<String>) {
        this.windowsFxVersion = value
    }

    /**
     * @param value Explicit Managed Service Identity Id
     */
    @JvmName("wbhfsolgjcjmmjbm")
    public suspend fun xManagedServiceIdentityId(`value`: Output<Int>) {
        this.xManagedServiceIdentityId = value
    }

    /**
     * @param value Flag to use Managed Identity Creds for ACR pull
     */
    @JvmName("sxhrjhdbpgrksxhh")
    public suspend fun acrUseManagedIdentityCreds(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrUseManagedIdentityCreds = mapped
    }

    /**
     * @param value If using user managed identity, the user managed identity ClientId
     */
    @JvmName("abuujvarwtfqshhd")
    public suspend fun acrUserManagedIdentityID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrUserManagedIdentityID = mapped
    }

    /**
     * @param value <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
     */
    @JvmName("opiyncutndfoonrv")
    public suspend fun alwaysOn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alwaysOn = mapped
    }

    /**
     * @param value Information about the formal API definition for the app.
     */
    @JvmName("htorcdatfudrmgwo")
    public suspend fun apiDefinition(`value`: ApiDefinitionInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiDefinition = mapped
    }

    /**
     * @param argument Information about the formal API definition for the app.
     */
    @JvmName("ccontfpcduomtmvq")
    public suspend fun apiDefinition(argument: suspend ApiDefinitionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ApiDefinitionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiDefinition = mapped
    }

    /**
     * @param value Azure API management settings linked to the app.
     */
    @JvmName("ausdfradnebstece")
    public suspend fun apiManagementConfig(`value`: ApiManagementConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiManagementConfig = mapped
    }

    /**
     * @param argument Azure API management settings linked to the app.
     */
    @JvmName("mdykphdboouqfaqd")
    public suspend
    fun apiManagementConfig(argument: suspend ApiManagementConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ApiManagementConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiManagementConfig = mapped
    }

    /**
     * @param value App command line to launch.
     */
    @JvmName("xkdjofvpmuywpcnl")
    public suspend fun appCommandLine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appCommandLine = mapped
    }

    /**
     * @param value Application settings.
     */
    @JvmName("rrexsksycvuurihm")
    public suspend fun appSettings(`value`: List<NameValuePairArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSettings = mapped
    }

    /**
     * @param argument Application settings.
     */
    @JvmName("qapcvrnjfhjnhyun")
    public suspend fun appSettings(argument: List<suspend NameValuePairArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.appSettings = mapped
    }

    /**
     * @param argument Application settings.
     */
    @JvmName("npdsbbmyybxlwnmd")
    public suspend fun appSettings(vararg argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.appSettings = mapped
    }

    /**
     * @param argument Application settings.
     */
    @JvmName("ggilrnmohsuqfhpg")
    public suspend fun appSettings(argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NameValuePairArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.appSettings = mapped
    }

    /**
     * @param values Application settings.
     */
    @JvmName("pqynbyqyipsgwcqx")
    public suspend fun appSettings(vararg values: NameValuePairArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appSettings = mapped
    }

    /**
     * @param value <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
     */
    @JvmName("ngymkecicfapqokk")
    public suspend fun autoHealEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealEnabled = mapped
    }

    /**
     * @param value Auto Heal rules.
     */
    @JvmName("hxvxonxtyugbuqia")
    public suspend fun autoHealRules(`value`: AutoHealRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoHealRules = mapped
    }

    /**
     * @param argument Auto Heal rules.
     */
    @JvmName("tglnbgwelwtgfgfa")
    public suspend fun autoHealRules(argument: suspend AutoHealRulesArgsBuilder.() -> Unit) {
        val toBeMapped = AutoHealRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoHealRules = mapped
    }

    /**
     * @param value Auto-swap slot name.
     */
    @JvmName("tfcyoywkyllyvjoe")
    public suspend fun autoSwapSlotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoSwapSlotName = mapped
    }

    /**
     * @param value List of Azure Storage Accounts.
     */
    @JvmName("vjfmagothgcotjmc")
    public suspend fun azureStorageAccounts(`value`: Map<String, AzureStorageInfoValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureStorageAccounts = mapped
    }

    /**
     * @param argument List of Azure Storage Accounts.
     */
    @JvmName("fknebcfhftthgjgq")
    public suspend fun azureStorageAccounts(
        vararg
        argument: Pair<String, suspend AzureStorageInfoValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                AzureStorageInfoValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.azureStorageAccounts = mapped
    }

    /**
     * @param values List of Azure Storage Accounts.
     */
    @JvmName("cnytscgrmlqrawxq")
    public fun azureStorageAccounts(vararg values: Pair<String, AzureStorageInfoValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageAccounts = mapped
    }

    /**
     * @param value Connection strings.
     */
    @JvmName("ocynfdulcvdstycf")
    public suspend fun connectionStrings(`value`: List<ConnStringInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStrings = mapped
    }

    /**
     * @param argument Connection strings.
     */
    @JvmName("vuamfsregwhusquw")
    public suspend
    fun connectionStrings(argument: List<suspend ConnStringInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnStringInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectionStrings = mapped
    }

    /**
     * @param argument Connection strings.
     */
    @JvmName("lpqxxnqmxlufikxp")
    public suspend fun connectionStrings(
        vararg
        argument: suspend ConnStringInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnStringInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectionStrings = mapped
    }

    /**
     * @param argument Connection strings.
     */
    @JvmName("skgxeesxemvqkmka")
    public suspend fun connectionStrings(argument: suspend ConnStringInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ConnStringInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.connectionStrings = mapped
    }

    /**
     * @param values Connection strings.
     */
    @JvmName("fkesqrqabhgwwyhi")
    public suspend fun connectionStrings(vararg values: ConnStringInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionStrings = mapped
    }

    /**
     * @param value Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("fafoqkojdrkprqls")
    public suspend fun cors(`value`: CorsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument Cross-Origin Resource Sharing (CORS) settings.
     */
    @JvmName("iuwntffbhwqmhedl")
    public suspend fun cors(argument: suspend CorsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = CorsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value Default documents.
     */
    @JvmName("bddtbratohwuxsnf")
    public suspend fun defaultDocuments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDocuments = mapped
    }

    /**
     * @param values Default documents.
     */
    @JvmName("wqroudnrskiohrnk")
    public suspend fun defaultDocuments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultDocuments = mapped
    }

    /**
     * @param value <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("dssqhwhcenjellwk")
    public suspend fun detailedErrorLoggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailedErrorLoggingEnabled = mapped
    }

    /**
     * @param value Document root.
     */
    @JvmName("kjvdlfjrkcllyhci")
    public suspend fun documentRoot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentRoot = mapped
    }

    /**
     * @param value Maximum number of workers that a site can scale out to.
     * This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
     */
    @JvmName("abymchdbijdklfge")
    public suspend fun elasticWebAppScaleLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticWebAppScaleLimit = mapped
    }

    /**
     * @param value This is work around for polymorphic types.
     */
    @JvmName("rjwndpfdhifeignv")
    public suspend fun experiments(`value`: ExperimentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experiments = mapped
    }

    /**
     * @param argument This is work around for polymorphic types.
     */
    @JvmName("yiycglutbxtkdhlq")
    public suspend fun experiments(argument: suspend ExperimentsArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.experiments = mapped
    }

    /**
     * @param value State of FTP / FTPS service
     */
    @JvmName("smfobdngonwqppbc")
    public suspend fun ftpsState(`value`: Either<String, FtpsState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ftpsState = mapped
    }

    /**
     * @param value State of FTP / FTPS service
     */
    @JvmName("krcblhlompdgprxt")
    public fun ftpsState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FtpsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ftpsState = mapped
    }

    /**
     * @param value State of FTP / FTPS service
     */
    @JvmName("yvddftjrfpllurbm")
    public fun ftpsState(`value`: FtpsState) {
        val toBeMapped = Either.ofRight<String, FtpsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ftpsState = mapped
    }

    /**
     * @param value Maximum number of workers that a site can scale out to.
     * This setting only applies to the Consumption and Elastic Premium Plans
     */
    @JvmName("lcshlpuvjxtyvnqb")
    public suspend fun functionAppScaleLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionAppScaleLimit = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
     * the ScaleController will not monitor event sources directly, but will instead call to the
     * runtime to get scale status.
     */
    @JvmName("vamnnhcfgfxisdef")
    public suspend fun functionsRuntimeScaleMonitoringEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionsRuntimeScaleMonitoringEnabled = mapped
    }

    /**
     * @param value Handler mappings.
     */
    @JvmName("kxnbggstrfgscpoo")
    public suspend fun handlerMappings(`value`: List<HandlerMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handlerMappings = mapped
    }

    /**
     * @param argument Handler mappings.
     */
    @JvmName("cibnkiehhquubsgj")
    public suspend fun handlerMappings(argument: List<suspend HandlerMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HandlerMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.handlerMappings = mapped
    }

    /**
     * @param argument Handler mappings.
     */
    @JvmName("ihmexwjcipiefjim")
    public suspend fun handlerMappings(
        vararg
        argument: suspend HandlerMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HandlerMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.handlerMappings = mapped
    }

    /**
     * @param argument Handler mappings.
     */
    @JvmName("ynbqhtufsacnbacx")
    public suspend fun handlerMappings(argument: suspend HandlerMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HandlerMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.handlerMappings = mapped
    }

    /**
     * @param values Handler mappings.
     */
    @JvmName("xiintbvgnmevwcsj")
    public suspend fun handlerMappings(vararg values: HandlerMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.handlerMappings = mapped
    }

    /**
     * @param value Health check path
     */
    @JvmName("wvfnbunatneaurrl")
    public suspend fun healthCheckPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckPath = mapped
    }

    /**
     * @param value Http20Enabled: configures a web site to allow clients to connect over http2.0
     */
    @JvmName("odrkcuetdueevfmf")
    public suspend fun http20Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http20Enabled = mapped
    }

    /**
     * @param value <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("nsoncmgpnvbrkncn")
    public suspend fun httpLoggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpLoggingEnabled = mapped
    }

    /**
     * @param value IP security restrictions for main.
     */
    @JvmName("ndejsndjqiqvqqra")
    public suspend fun ipSecurityRestrictions(`value`: List<IpSecurityRestrictionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for main.
     */
    @JvmName("cpvwwtvmpdhfgtee")
    public suspend
    fun ipSecurityRestrictions(argument: List<suspend IpSecurityRestrictionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for main.
     */
    @JvmName("jdjyuwakvpeumjco")
    public suspend fun ipSecurityRestrictions(
        vararg
        argument: suspend IpSecurityRestrictionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for main.
     */
    @JvmName("slutvoweoktbhkuy")
    public suspend
    fun ipSecurityRestrictions(argument: suspend IpSecurityRestrictionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpSecurityRestrictionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param values IP security restrictions for main.
     */
    @JvmName("yxifvtesxducrqgc")
    public suspend fun ipSecurityRestrictions(vararg values: IpSecurityRestrictionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param value Default action for main access restriction if no rules are matched.
     */
    @JvmName("rhmgotuxbuuvaeok")
    public suspend fun ipSecurityRestrictionsDefaultAction(`value`: Either<String, DefaultAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Default action for main access restriction if no rules are matched.
     */
    @JvmName("mtfclpgvtnrtletb")
    public fun ipSecurityRestrictionsDefaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Default action for main access restriction if no rules are matched.
     */
    @JvmName("ckoucumobdkasmdx")
    public fun ipSecurityRestrictionsDefaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Java container.
     */
    @JvmName("dcjfnyqhwgkmobny")
    public suspend fun javaContainer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.javaContainer = mapped
    }

    /**
     * @param value Java container version.
     */
    @JvmName("ansnmehjfgimivbh")
    public suspend fun javaContainerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.javaContainerVersion = mapped
    }

    /**
     * @param value Java version.
     */
    @JvmName("jqqxfageacuquhce")
    public suspend fun javaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.javaVersion = mapped
    }

    /**
     * @param value Identity to use for Key Vault Reference authentication.
     */
    @JvmName("ugehaledkcxigiav")
    public suspend fun keyVaultReferenceIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultReferenceIdentity = mapped
    }

    /**
     * @param value Site limits.
     */
    @JvmName("nctneobqwsaomrxn")
    public suspend fun limits(`value`: SiteLimitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Site limits.
     */
    @JvmName("ytbfdialybakfdwu")
    public suspend fun limits(argument: suspend SiteLimitsArgsBuilder.() -> Unit) {
        val toBeMapped = SiteLimitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value Linux App Framework and version
     */
    @JvmName("pnodjkgnkyqrqdee")
    public suspend fun linuxFxVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxFxVersion = mapped
    }

    /**
     * @param value Site load balancing.
     */
    @JvmName("lcicpiygwapodeqt")
    public suspend fun loadBalancing(`value`: SiteLoadBalancing?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancing = mapped
    }

    /**
     * @param value <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
     */
    @JvmName("juunqignxxbsxlwh")
    public suspend fun localMySqlEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localMySqlEnabled = mapped
    }

    /**
     * @param value HTTP logs directory size limit.
     */
    @JvmName("lwsywqavuxyknqwt")
    public suspend fun logsDirectorySizeLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logsDirectorySizeLimit = mapped
    }

    /**
     * @param value Managed pipeline mode.
     */
    @JvmName("suxyxtudnochybqx")
    public suspend fun managedPipelineMode(`value`: ManagedPipelineMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPipelineMode = mapped
    }

    /**
     * @param value Managed Service Identity Id
     */
    @JvmName("qhvnfenhrvmsamnq")
    public suspend fun managedServiceIdentityId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedServiceIdentityId = mapped
    }

    /**
     * @param value Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("bxmmghfvpwpmpdjk")
    public suspend fun metadata(`value`: List<NameValuePairArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("uoykfboleeraygxj")
    public suspend fun metadata(argument: List<suspend NameValuePairArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("chbgjqiiedehnmvu")
    public suspend fun metadata(vararg argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NameValuePairArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("exfnaskonmerdlno")
    public suspend fun metadata(argument: suspend NameValuePairArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NameValuePairArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Application metadata. This property cannot be retrieved, since it may contain secrets.
     */
    @JvmName("vqpqjjsukckkkpka")
    public suspend fun metadata(vararg values: NameValuePairArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    @JvmName("yolikxkdtpawvqtw")
    public suspend fun minTlsVersion(`value`: Either<String, SupportedTlsVersions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTlsVersion = mapped
    }

    /**
     * @param value MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    @JvmName("tvmtwojydaaqnxgm")
    public fun minTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SupportedTlsVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minTlsVersion = mapped
    }

    /**
     * @param value MinTlsVersion: configures the minimum version of TLS required for SSL requests
     */
    @JvmName("exekuoltrphyrisb")
    public fun minTlsVersion(`value`: SupportedTlsVersions) {
        val toBeMapped = Either.ofRight<String, SupportedTlsVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minTlsVersion = mapped
    }

    /**
     * @param value Number of minimum instance count for a site
     * This setting only applies to the Elastic Plans
     */
    @JvmName("iagxhrtderluxcdp")
    public suspend fun minimumElasticInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumElasticInstanceCount = mapped
    }

    /**
     * @param value .NET Framework version.
     */
    @JvmName("yusmtauuucqywtfm")
    public suspend fun netFrameworkVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netFrameworkVersion = mapped
    }

    /**
     * @param value Version of Node.js.
     */
    @JvmName("sxxmdvujxuhnjnoq")
    public suspend fun nodeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeVersion = mapped
    }

    /**
     * @param value Number of workers.
     */
    @JvmName("ekcwgfbajivqhccc")
    public suspend fun numberOfWorkers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfWorkers = mapped
    }

    /**
     * @param value Version of PHP.
     */
    @JvmName("vmtydxbvoadekhpl")
    public suspend fun phpVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phpVersion = mapped
    }

    /**
     * @param value Version of PowerShell.
     */
    @JvmName("pocudhuryfsxqtmq")
    public suspend fun powerShellVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.powerShellVersion = mapped
    }

    /**
     * @param value Number of preWarmed instances.
     * This setting only applies to the Consumption and Elastic Plans
     */
    @JvmName("diriuxgmfmpseknd")
    public suspend fun preWarmedInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preWarmedInstanceCount = mapped
    }

    /**
     * @param value Property to allow or block all public traffic.
     */
    @JvmName("ymncxvoxrpogqrtu")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Publishing user name.
     */
    @JvmName("oydwtvprsvrthywo")
    public suspend fun publishingUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishingUsername = mapped
    }

    /**
     * @param value Push endpoint settings.
     */
    @JvmName("hybfjqacggxnrlgs")
    public suspend fun push(`value`: PushSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.push = mapped
    }

    /**
     * @param argument Push endpoint settings.
     */
    @JvmName("qabmuesqmlakrsrw")
    public suspend fun push(argument: suspend PushSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PushSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.push = mapped
    }

    /**
     * @param value Version of Python.
     */
    @JvmName("vmawuwdaeodnudlv")
    public suspend fun pythonVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pythonVersion = mapped
    }

    /**
     * @param value <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
     */
    @JvmName("dkjkndbeliveujvl")
    public suspend fun remoteDebuggingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDebuggingEnabled = mapped
    }

    /**
     * @param value Remote debugging version.
     */
    @JvmName("sdpkebfeojggwqeb")
    public suspend fun remoteDebuggingVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteDebuggingVersion = mapped
    }

    /**
     * @param value <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
     */
    @JvmName("hfcvawlyrymewudc")
    public suspend fun requestTracingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTracingEnabled = mapped
    }

    /**
     * @param value Request tracing expiration time.
     */
    @JvmName("sprsxvjwklgmybti")
    public suspend fun requestTracingExpirationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTracingExpirationTime = mapped
    }

    /**
     * @param value IP security restrictions for scm.
     */
    @JvmName("wcauawfjfuyedvwa")
    public suspend fun scmIpSecurityRestrictions(`value`: List<IpSecurityRestrictionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for scm.
     */
    @JvmName("qvdyeechobnwwywb")
    public suspend
    fun scmIpSecurityRestrictions(argument: List<suspend IpSecurityRestrictionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for scm.
     */
    @JvmName("ebwlxjkhalxjsljk")
    public suspend fun scmIpSecurityRestrictions(
        vararg
        argument: suspend IpSecurityRestrictionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param argument IP security restrictions for scm.
     */
    @JvmName("ckekbmuefsutixkf")
    public suspend
    fun scmIpSecurityRestrictions(argument: suspend IpSecurityRestrictionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpSecurityRestrictionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param values IP security restrictions for scm.
     */
    @JvmName("skkqsooidlpmsujb")
    public suspend fun scmIpSecurityRestrictions(vararg values: IpSecurityRestrictionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictions = mapped
    }

    /**
     * @param value Default action for scm access restriction if no rules are matched.
     */
    @JvmName("dvlmxhtucwlfjoqe")
    public suspend
    fun scmIpSecurityRestrictionsDefaultAction(`value`: Either<String, DefaultAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Default action for scm access restriction if no rules are matched.
     */
    @JvmName("htbsikudebbjwfmd")
    public fun scmIpSecurityRestrictionsDefaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value Default action for scm access restriction if no rules are matched.
     */
    @JvmName("fswggsqhhssehlek")
    public fun scmIpSecurityRestrictionsDefaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictionsDefaultAction = mapped
    }

    /**
     * @param value IP security restrictions for scm to use main.
     */
    @JvmName("dylphyjqmpoffouj")
    public suspend fun scmIpSecurityRestrictionsUseMain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmIpSecurityRestrictionsUseMain = mapped
    }

    /**
     * @param value ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    @JvmName("dygvqjgbyxinrtdt")
    public suspend fun scmMinTlsVersion(`value`: Either<String, SupportedTlsVersions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmMinTlsVersion = mapped
    }

    /**
     * @param value ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    @JvmName("samfdigmigngoyud")
    public fun scmMinTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SupportedTlsVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmMinTlsVersion = mapped
    }

    /**
     * @param value ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
     */
    @JvmName("issfrxjguiimffok")
    public fun scmMinTlsVersion(`value`: SupportedTlsVersions) {
        val toBeMapped = Either.ofRight<String, SupportedTlsVersions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmMinTlsVersion = mapped
    }

    /**
     * @param value SCM type.
     */
    @JvmName("wwyukqunlrtqmtim")
    public suspend fun scmType(`value`: Either<String, ScmType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scmType = mapped
    }

    /**
     * @param value SCM type.
     */
    @JvmName("mrldxtdgjukjxwml")
    public fun scmType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScmType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmType = mapped
    }

    /**
     * @param value SCM type.
     */
    @JvmName("cfbhhasbbicwqhyx")
    public fun scmType(`value`: ScmType) {
        val toBeMapped = Either.ofRight<String, ScmType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scmType = mapped
    }

    /**
     * @param value Tracing options.
     */
    @JvmName("hdrwtcphydwjxilx")
    public suspend fun tracingOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingOptions = mapped
    }

    /**
     * @param value <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
     */
    @JvmName("reogtijllxgwdkno")
    public suspend fun use32BitWorkerProcess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.use32BitWorkerProcess = mapped
    }

    /**
     * @param value Virtual applications.
     */
    @JvmName("ykgkfmfqlbygijus")
    public suspend fun virtualApplications(`value`: List<VirtualApplicationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualApplications = mapped
    }

    /**
     * @param argument Virtual applications.
     */
    @JvmName("tcfasxmfxfhyrqhf")
    public suspend
    fun virtualApplications(argument: List<suspend VirtualApplicationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualApplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param argument Virtual applications.
     */
    @JvmName("dssoblhljmgljwlp")
    public suspend fun virtualApplications(
        vararg
        argument: suspend VirtualApplicationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualApplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param argument Virtual applications.
     */
    @JvmName("hodaqsekfhwiqddn")
    public suspend
    fun virtualApplications(argument: suspend VirtualApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualApplicationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualApplications = mapped
    }

    /**
     * @param values Virtual applications.
     */
    @JvmName("codohvhptsfyigni")
    public suspend fun virtualApplications(vararg values: VirtualApplicationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualApplications = mapped
    }

    /**
     * @param value Virtual Network name.
     */
    @JvmName("ojyekhtwacgfqjgd")
    public suspend fun vnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetName = mapped
    }

    /**
     * @param value The number of private ports assigned to this app. These will be assigned dynamically on runtime.
     */
    @JvmName("expxbayvsrvrowkr")
    public suspend fun vnetPrivatePortsCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetPrivatePortsCount = mapped
    }

    /**
     * @param value Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
     */
    @JvmName("hchjvikyumxumwkd")
    public suspend fun vnetRouteAllEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetRouteAllEnabled = mapped
    }

    /**
     * @param value <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
     */
    @JvmName("ikohafrosvdaigrw")
    public suspend fun webSocketsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webSocketsEnabled = mapped
    }

    /**
     * @param value Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
     */
    @JvmName("sridksdmqpdnjado")
    public suspend fun websiteTimeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.websiteTimeZone = mapped
    }

    /**
     * @param value Xenon App Framework and version
     */
    @JvmName("ctepirdxmtkthuye")
    public suspend fun windowsFxVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsFxVersion = mapped
    }

    /**
     * @param value Explicit Managed Service Identity Id
     */
    @JvmName("soovjjkymgwifmkm")
    public suspend fun xManagedServiceIdentityId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xManagedServiceIdentityId = mapped
    }

    internal fun build(): SiteConfigArgs = SiteConfigArgs(
        acrUseManagedIdentityCreds = acrUseManagedIdentityCreds,
        acrUserManagedIdentityID = acrUserManagedIdentityID,
        alwaysOn = alwaysOn,
        apiDefinition = apiDefinition,
        apiManagementConfig = apiManagementConfig,
        appCommandLine = appCommandLine,
        appSettings = appSettings,
        autoHealEnabled = autoHealEnabled,
        autoHealRules = autoHealRules,
        autoSwapSlotName = autoSwapSlotName,
        azureStorageAccounts = azureStorageAccounts,
        connectionStrings = connectionStrings,
        cors = cors,
        defaultDocuments = defaultDocuments,
        detailedErrorLoggingEnabled = detailedErrorLoggingEnabled,
        documentRoot = documentRoot,
        elasticWebAppScaleLimit = elasticWebAppScaleLimit,
        experiments = experiments,
        ftpsState = ftpsState,
        functionAppScaleLimit = functionAppScaleLimit,
        functionsRuntimeScaleMonitoringEnabled = functionsRuntimeScaleMonitoringEnabled,
        handlerMappings = handlerMappings,
        healthCheckPath = healthCheckPath,
        http20Enabled = http20Enabled,
        httpLoggingEnabled = httpLoggingEnabled,
        ipSecurityRestrictions = ipSecurityRestrictions,
        ipSecurityRestrictionsDefaultAction = ipSecurityRestrictionsDefaultAction,
        javaContainer = javaContainer,
        javaContainerVersion = javaContainerVersion,
        javaVersion = javaVersion,
        keyVaultReferenceIdentity = keyVaultReferenceIdentity,
        limits = limits,
        linuxFxVersion = linuxFxVersion,
        loadBalancing = loadBalancing,
        localMySqlEnabled = localMySqlEnabled,
        logsDirectorySizeLimit = logsDirectorySizeLimit,
        managedPipelineMode = managedPipelineMode,
        managedServiceIdentityId = managedServiceIdentityId,
        metadata = metadata,
        minTlsVersion = minTlsVersion,
        minimumElasticInstanceCount = minimumElasticInstanceCount,
        netFrameworkVersion = netFrameworkVersion,
        nodeVersion = nodeVersion,
        numberOfWorkers = numberOfWorkers,
        phpVersion = phpVersion,
        powerShellVersion = powerShellVersion,
        preWarmedInstanceCount = preWarmedInstanceCount,
        publicNetworkAccess = publicNetworkAccess,
        publishingUsername = publishingUsername,
        push = push,
        pythonVersion = pythonVersion,
        remoteDebuggingEnabled = remoteDebuggingEnabled,
        remoteDebuggingVersion = remoteDebuggingVersion,
        requestTracingEnabled = requestTracingEnabled,
        requestTracingExpirationTime = requestTracingExpirationTime,
        scmIpSecurityRestrictions = scmIpSecurityRestrictions,
        scmIpSecurityRestrictionsDefaultAction = scmIpSecurityRestrictionsDefaultAction,
        scmIpSecurityRestrictionsUseMain = scmIpSecurityRestrictionsUseMain,
        scmMinTlsVersion = scmMinTlsVersion,
        scmType = scmType,
        tracingOptions = tracingOptions,
        use32BitWorkerProcess = use32BitWorkerProcess,
        virtualApplications = virtualApplications,
        vnetName = vnetName,
        vnetPrivatePortsCount = vnetPrivatePortsCount,
        vnetRouteAllEnabled = vnetRouteAllEnabled,
        webSocketsEnabled = webSocketsEnabled,
        websiteTimeZone = websiteTimeZone,
        windowsFxVersion = windowsFxVersion,
        xManagedServiceIdentityId = xManagedServiceIdentityId,
    )
}
