@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.TemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App versioned application definition.
 * Defines the desired state of an immutable revision.
 * Any changes to this section Will result in a new revision being created
 * @property containers List of container definitions for the Container App.
 * @property dapr Dapr configuration for the Container App.
 * @property revisionSuffix User friendly suffix that is appended to the revision name
 * @property scale Scaling properties for the Container App.
 */
public data class TemplateArgs(
    public val containers: Output<List<ContainerArgs>>? = null,
    public val dapr: Output<DaprArgs>? = null,
    public val revisionSuffix: Output<String>? = null,
    public val scale: Output<ScaleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.TemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.TemplateArgs =
        com.pulumi.azurenative.web.inputs.TemplateArgs.builder()
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dapr(dapr?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .revisionSuffix(revisionSuffix?.applyValue({ args0 -> args0 }))
            .scale(scale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TemplateArgs].
 */
@PulumiTagMarker
public class TemplateArgsBuilder internal constructor() {
    private var containers: Output<List<ContainerArgs>>? = null

    private var dapr: Output<DaprArgs>? = null

    private var revisionSuffix: Output<String>? = null

    private var scale: Output<ScaleArgs>? = null

    /**
     * @param value List of container definitions for the Container App.
     */
    @JvmName("btdkvuhsycvpyjus")
    public suspend fun containers(`value`: Output<List<ContainerArgs>>) {
        this.containers = value
    }

    @JvmName("cflntljwwxidsgaj")
    public suspend fun containers(vararg values: Output<ContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values List of container definitions for the Container App.
     */
    @JvmName("gpxhugcynpglbpub")
    public suspend fun containers(values: List<Output<ContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value Dapr configuration for the Container App.
     */
    @JvmName("giivovjgsesyacqm")
    public suspend fun dapr(`value`: Output<DaprArgs>) {
        this.dapr = value
    }

    /**
     * @param value User friendly suffix that is appended to the revision name
     */
    @JvmName("vlsghusuyehokmhx")
    public suspend fun revisionSuffix(`value`: Output<String>) {
        this.revisionSuffix = value
    }

    /**
     * @param value Scaling properties for the Container App.
     */
    @JvmName("yftdfqebdtudsyes")
    public suspend fun scale(`value`: Output<ScaleArgs>) {
        this.scale = value
    }

    /**
     * @param value List of container definitions for the Container App.
     */
    @JvmName("ewbotwmwqdvprkay")
    public suspend fun containers(`value`: List<ContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("stkxdxsilesmksnu")
    public suspend fun containers(argument: List<suspend ContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ContainerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("cbyilrirwsmuxemt")
    public suspend fun containers(vararg argument: suspend ContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ContainerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("lwgtleogxbafansq")
    public suspend fun containers(argument: suspend ContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values List of container definitions for the Container App.
     */
    @JvmName("faoghusgrlwevgix")
    public suspend fun containers(vararg values: ContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value Dapr configuration for the Container App.
     */
    @JvmName("opvntpckrrnoooxy")
    public suspend fun dapr(`value`: DaprArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dapr = mapped
    }

    /**
     * @param argument Dapr configuration for the Container App.
     */
    @JvmName("unsosrgpmamicfns")
    public suspend fun dapr(argument: suspend DaprArgsBuilder.() -> Unit) {
        val toBeMapped = DaprArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dapr = mapped
    }

    /**
     * @param value User friendly suffix that is appended to the revision name
     */
    @JvmName("pxbplgrqlxlnsffe")
    public suspend fun revisionSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revisionSuffix = mapped
    }

    /**
     * @param value Scaling properties for the Container App.
     */
    @JvmName("vngrybkjftgqukwo")
    public suspend fun scale(`value`: ScaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scale = mapped
    }

    /**
     * @param argument Scaling properties for the Container App.
     */
    @JvmName("lrmtlqpukfwlwury")
    public suspend fun scale(argument: suspend ScaleArgsBuilder.() -> Unit) {
        val toBeMapped = ScaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scale = mapped
    }

    internal fun build(): TemplateArgs = TemplateArgs(
        containers = containers,
        dapr = dapr,
        revisionSuffix = revisionSuffix,
        scale = scale,
    )
}
