@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.TrafficWeightArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Traffic weight assigned to a revision
 * @property latestRevision Indicates that the traffic weight belongs to a latest stable revision
 * @property revisionName Name of a revision
 * @property weight Traffic weight assigned to a revision
 */
public data class TrafficWeightArgs(
    public val latestRevision: Output<Boolean>? = null,
    public val revisionName: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.TrafficWeightArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.TrafficWeightArgs =
        com.pulumi.azurenative.web.inputs.TrafficWeightArgs.builder()
            .latestRevision(latestRevision?.applyValue({ args0 -> args0 }))
            .revisionName(revisionName?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficWeightArgs].
 */
@PulumiTagMarker
public class TrafficWeightArgsBuilder internal constructor() {
    private var latestRevision: Output<Boolean>? = null

    private var revisionName: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value Indicates that the traffic weight belongs to a latest stable revision
     */
    @JvmName("njidoubgxtmljrud")
    public suspend fun latestRevision(`value`: Output<Boolean>) {
        this.latestRevision = value
    }

    /**
     * @param value Name of a revision
     */
    @JvmName("kqtaumryxuoodwbr")
    public suspend fun revisionName(`value`: Output<String>) {
        this.revisionName = value
    }

    /**
     * @param value Traffic weight assigned to a revision
     */
    @JvmName("wnctdtitytmdiqtn")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value Indicates that the traffic weight belongs to a latest stable revision
     */
    @JvmName("irulkmkccglpfuwv")
    public suspend fun latestRevision(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latestRevision = mapped
    }

    /**
     * @param value Name of a revision
     */
    @JvmName("lvaiwbqupxpcwqmv")
    public suspend fun revisionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revisionName = mapped
    }

    /**
     * @param value Traffic weight assigned to a revision
     */
    @JvmName("wlsrxapfycpbaeql")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): TrafficWeightArgs = TrafficWeightArgs(
        latestRevision = latestRevision,
        revisionName = revisionName,
        weight = weight,
    )
}
