@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.VirtualApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Virtual application in an app.
 * @property physicalPath Physical path.
 * @property preloadEnabled <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
 * @property virtualDirectories Virtual directories for virtual application.
 * @property virtualPath Virtual path.
 */
public data class VirtualApplicationArgs(
    public val physicalPath: Output<String>? = null,
    public val preloadEnabled: Output<Boolean>? = null,
    public val virtualDirectories: Output<List<VirtualDirectoryArgs>>? = null,
    public val virtualPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.VirtualApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.VirtualApplicationArgs =
        com.pulumi.azurenative.web.inputs.VirtualApplicationArgs.builder()
            .physicalPath(physicalPath?.applyValue({ args0 -> args0 }))
            .preloadEnabled(preloadEnabled?.applyValue({ args0 -> args0 }))
            .virtualDirectories(
                virtualDirectories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualPath(virtualPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualApplicationArgs].
 */
@PulumiTagMarker
public class VirtualApplicationArgsBuilder internal constructor() {
    private var physicalPath: Output<String>? = null

    private var preloadEnabled: Output<Boolean>? = null

    private var virtualDirectories: Output<List<VirtualDirectoryArgs>>? = null

    private var virtualPath: Output<String>? = null

    /**
     * @param value Physical path.
     */
    @JvmName("bgchofjettmkjcrv")
    public suspend fun physicalPath(`value`: Output<String>) {
        this.physicalPath = value
    }

    /**
     * @param value <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
     */
    @JvmName("ngcunwuoaelfigdo")
    public suspend fun preloadEnabled(`value`: Output<Boolean>) {
        this.preloadEnabled = value
    }

    /**
     * @param value Virtual directories for virtual application.
     */
    @JvmName("kieylvuexwvtgduq")
    public suspend fun virtualDirectories(`value`: Output<List<VirtualDirectoryArgs>>) {
        this.virtualDirectories = value
    }

    @JvmName("oahwxuknfnbjxuuh")
    public suspend fun virtualDirectories(vararg values: Output<VirtualDirectoryArgs>) {
        this.virtualDirectories = Output.all(values.asList())
    }

    /**
     * @param values Virtual directories for virtual application.
     */
    @JvmName("dngchgoouvgrsrnt")
    public suspend fun virtualDirectories(values: List<Output<VirtualDirectoryArgs>>) {
        this.virtualDirectories = Output.all(values)
    }

    /**
     * @param value Virtual path.
     */
    @JvmName("grrfnvdfaawatwgx")
    public suspend fun virtualPath(`value`: Output<String>) {
        this.virtualPath = value
    }

    /**
     * @param value Physical path.
     */
    @JvmName("fxwpfevpavlxjjhh")
    public suspend fun physicalPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalPath = mapped
    }

    /**
     * @param value <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
     */
    @JvmName("afgcterlmgtolwdh")
    public suspend fun preloadEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preloadEnabled = mapped
    }

    /**
     * @param value Virtual directories for virtual application.
     */
    @JvmName("ggensxmcifaiqfvg")
    public suspend fun virtualDirectories(`value`: List<VirtualDirectoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualDirectories = mapped
    }

    /**
     * @param argument Virtual directories for virtual application.
     */
    @JvmName("ngdbylsjavoxyjif")
    public suspend
    fun virtualDirectories(argument: List<suspend VirtualDirectoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualDirectories = mapped
    }

    /**
     * @param argument Virtual directories for virtual application.
     */
    @JvmName("yvykkbhvcqsgpsvk")
    public suspend fun virtualDirectories(
        vararg
        argument: suspend VirtualDirectoryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualDirectories = mapped
    }

    /**
     * @param argument Virtual directories for virtual application.
     */
    @JvmName("eairiulfkqdinvll")
    public suspend fun virtualDirectories(argument: suspend VirtualDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualDirectoryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualDirectories = mapped
    }

    /**
     * @param values Virtual directories for virtual application.
     */
    @JvmName("hsvklwdcncxpyqlp")
    public suspend fun virtualDirectories(vararg values: VirtualDirectoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualDirectories = mapped
    }

    /**
     * @param value Virtual path.
     */
    @JvmName("iupagswkatontbgl")
    public suspend fun virtualPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualPath = mapped
    }

    internal fun build(): VirtualApplicationArgs = VirtualApplicationArgs(
        physicalPath = physicalPath,
        preloadEnabled = preloadEnabled,
        virtualDirectories = virtualDirectories,
        virtualPath = virtualPath,
    )
}
