@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.inputs

import com.pulumi.azurenative.web.inputs.WsdlDefinitionArgs.builder
import com.pulumi.azurenative.web.kotlin.enums.WsdlImportMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The WSDL definition
 * @property content The WSDL content
 * @property importMethod The WSDL import method
 * @property service The service with name and endpoint names
 * @property url The WSDL URL
 */
public data class WsdlDefinitionArgs(
    public val content: Output<String>? = null,
    public val importMethod: Output<Either<String, WsdlImportMethod>>? = null,
    public val service: Output<WsdlServiceArgs>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.web.inputs.WsdlDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.web.inputs.WsdlDefinitionArgs =
        com.pulumi.azurenative.web.inputs.WsdlDefinitionArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .importMethod(
                importMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .service(service?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WsdlDefinitionArgs].
 */
@PulumiTagMarker
public class WsdlDefinitionArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var importMethod: Output<Either<String, WsdlImportMethod>>? = null

    private var service: Output<WsdlServiceArgs>? = null

    private var url: Output<String>? = null

    /**
     * @param value The WSDL content
     */
    @JvmName("lddlisbfinkdgrli")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The WSDL import method
     */
    @JvmName("momuabcobsrlhner")
    public suspend fun importMethod(`value`: Output<Either<String, WsdlImportMethod>>) {
        this.importMethod = value
    }

    /**
     * @param value The service with name and endpoint names
     */
    @JvmName("jagemgdevylainxm")
    public suspend fun service(`value`: Output<WsdlServiceArgs>) {
        this.service = value
    }

    /**
     * @param value The WSDL URL
     */
    @JvmName("rvcgnwcqatxybvvo")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The WSDL content
     */
    @JvmName("mwfnccfodqsklnnq")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The WSDL import method
     */
    @JvmName("eqlpjnpkjtfpyqrs")
    public suspend fun importMethod(`value`: Either<String, WsdlImportMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importMethod = mapped
    }

    /**
     * @param value The WSDL import method
     */
    @JvmName("veduthoacfknaiwb")
    public fun importMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WsdlImportMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.importMethod = mapped
    }

    /**
     * @param value The WSDL import method
     */
    @JvmName("clwpbenvidlpccun")
    public fun importMethod(`value`: WsdlImportMethod) {
        val toBeMapped = Either.ofRight<String, WsdlImportMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.importMethod = mapped
    }

    /**
     * @param value The service with name and endpoint names
     */
    @JvmName("ulqooprjomjugrlo")
    public suspend fun service(`value`: WsdlServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.service = mapped
    }

    /**
     * @param argument The service with name and endpoint names
     */
    @JvmName("jytxjvpvoecgdyty")
    public suspend fun service(argument: suspend WsdlServiceArgsBuilder.() -> Unit) {
        val toBeMapped = WsdlServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.service = mapped
    }

    /**
     * @param value The WSDL URL
     */
    @JvmName("nskucigyxnuoxdsp")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): WsdlDefinitionArgs = WsdlDefinitionArgs(
        content = content,
        importMethod = importMethod,
        service = service,
        url = url,
    )
}
